/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.generator;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.ImportsManager;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelDependency;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;
import org.nuiton.topia.generator.TopiaGeneratorUtil;
import org.nuiton.topia.persistence.TopiaEntity;

@Deprecated
public class BeanGenerator
extends ObjectModelGenerator {
    private static final Log log = LogFactory.getLog(BeanGenerator.class);

    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + ".java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        boolean sortAttribute;
        if (!clazz.hasStereotype("bean") && !clazz.hasStereotype("dto")) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(this.model);
        String clazzName = clazz.getName();
        String abstractStr = this.isAbstract(clazz) ? " abstract " : " ";
        boolean needGetEntityMethod = false;
        boolean generateToString = TopiaGeneratorUtil.generateToString(clazz, (ObjectModel)this.model);
        ImportsManager imports = new ImportsManager();
        String extendClass = "";
        Iterator j = clazz.getSuperclasses().iterator();
        if (j.hasNext()) {
            ObjectModelClassifier p = (ObjectModelClassifier)j.next();
            imports.addImport(p.getQualifiedName());
            extendClass = extendClass + p.getName();
        }
        String implInterface = "";
        Iterator i = clazz.getInterfaces().iterator();
        while (i.hasNext()) {
            ObjectModelClassifier parentInterface = (ObjectModelClassifier)i.next();
            imports.addImport(parentInterface.getQualifiedName());
            implInterface = implInterface + parentInterface.getName();
            if (!i.hasNext()) continue;
            implInterface = implInterface + ", ";
        }
        if (clazz.hasStereotype("dto")) {
            imports.addImport(Serializable.class);
            if (!implInterface.isEmpty()) {
                implInterface = implInterface + ", ";
            }
            implInterface = implInterface + Serializable.class.getName();
        }
        String svUID = TopiaGeneratorUtil.findTagValue((String)"dto-serialVersionUID", (ObjectModelElement)clazz, (Model)this.model);
        ArrayList<ObjectModelAttribute> attributes = new ArrayList<ObjectModelAttribute>();
        ArrayList<ObjectModelAttribute> multipleAttr = new ArrayList<ObjectModelAttribute>();
        this.setAttributesForDTO(clazz, attributes, imports);
        boolean needListInImport = false;
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable()) continue;
            attributes.add(attr);
            imports.addImport(attr.getType());
            if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
            multipleAttr.add(attr);
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
            needGetEntityMethod |= isEntity;
            if (!attr.isOrdered()) continue;
            needListInImport = true;
        }
        imports.addImport(PropertyChangeListener.class.getName());
        imports.addImport(PropertyChangeSupport.class.getName());
        for (ObjectModelOperation operation : clazz.getOperations()) {
            imports.addImport(operation.getReturnType());
            for (ObjectModelParameter parameter : operation.getParameters()) {
                imports.addImport(parameter.getType());
            }
        }
        if (needGetEntityMethod) {
            imports.addImport(TopiaEntity.class);
        }
        if (!multipleAttr.isEmpty()) {
            imports.addImport(Collection.class);
        }
        if (needListInImport) {
            imports.addImport(List.class);
        }
        if (generateToString) {
            imports.addImport(ToStringBuilder.class);
        }
        if (sortAttribute = TopiaGeneratorUtil.sortAttribute(clazz, (ObjectModel)this.model)) {
            Comparator<ObjectModelAttribute> comp = new Comparator<ObjectModelAttribute>(){

                @Override
                public int compare(ObjectModelAttribute o1, ObjectModelAttribute o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            };
            Collections.sort(attributes, comp);
            Collections.sort(multipleAttr, comp);
        }
        if (TopiaGeneratorUtil.notEmpty((String)copyright)) {
            output.write("" + copyright + "\n");
            output.write("");
        }
        output.write("package " + clazz.getPackageName() + ";\n");
        output.write(" \n");
        output.write(" ");
        if (log.isDebugEnabled()) {
            log.debug((Object)("imports for class <" + clazzName + ">"));
        }
        for (String anImport : imports.getImports(clazz.getPackageName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("import " + anImport));
            }
            output.write("import " + anImport + ";\n");
            output.write("");
        }
        output.write("\n");
        output.write("public" + abstractStr + "class " + clazzName + "");
        if (extendClass.length() > 0) {
            output.write(" extends " + extendClass + "");
        }
        if (implInterface.length() > 0) {
            output.write(" implements " + implInterface + " {\n");
            output.write("\n");
            output.write("");
        } else {
            output.write(" {\n");
            output.write("\n");
            output.write("");
        }
        if (svUID != null) {
            output.write("    public static final long serialVersionUID = " + svUID + ";\n");
            output.write("\n");
            output.write("");
        }
        this.generateInterfaceOperations(output, (ObjectModelClassifier)clazz);
        this.generateAttributes(output, attributes);
        output.write("    protected final PropertyChangeSupport pcs;\n");
        output.write("\n");
        output.write("    /**\n");
        output.write("     * Default constructor of " + clazzName + ".\n");
        output.write("     */\n");
        output.write("    public " + clazzName + "() {\n");
        output.write("        pcs = new PropertyChangeSupport(this);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void addPropertyChangeListener(PropertyChangeListener listener) {\n");
        output.write("        pcs.addPropertyChangeListener(listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
        output.write("        pcs.addPropertyChangeListener(propertyName, listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void removePropertyChangeListener(PropertyChangeListener listener) {\n");
        output.write("        pcs.removePropertyChangeListener(listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {\n");
        output.write("        pcs.removePropertyChangeListener(propertyName, listener);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("");
        this.generateGetters(output, attributes);
        this.generateSetters(output, attributes);
        this.generateGetChild(output, multipleAttr);
        this.generateAddChild(output, multipleAttr);
        this.generateRemoveChild(output, multipleAttr);
        if (generateToString) {
            this.generateToString(output, clazz);
        }
        if (!multipleAttr.isEmpty()) {
            output.write("\n");
            output.write("    \n");
            output.write("    protected <T> T getChild(Collection<T> childs, int index) {\n");
            output.write("        if (childs != null) {\n");
            output.write("            int i = 0;\n");
            output.write("            for (T o : childs) {\n");
            output.write("                if (index == i) {\n");
            output.write("                    return o;\n");
            output.write("                }\n");
            output.write("                i++;\n");
            output.write("            }\n");
            output.write("        }\n");
            output.write("        return null;\n");
            output.write("    }\n");
            output.write("\n");
            output.write(" ");
            if (needGetEntityMethod) {
                output.write("    protected <T extends TopiaEntity> T getEntity(Collection<T> childs, String topiaId) {\n");
                output.write("        if (childs != null) {\n");
                output.write("            for (T o : childs) {\n");
                output.write("                if (topiaId.equals(o.getTopiaId())) {\n");
                output.write("                    return o;\n");
                output.write("                }\n");
                output.write("            }\n");
                output.write("        }\n");
                output.write("        return null;\n");
                output.write("    }\n");
                output.write(" ");
            }
        }
        output.write("\n");
        output.write("    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {\n");
        output.write("      pcs.firePropertyChange(propertyName, oldValue, newValue);\n");
        output.write("    }\n");
        output.write("\n");
        output.write("} //" + clazz.getName() + "\n");
        output.write("");
    }

    protected void generateAttributes(Writer output, List<ObjectModelAttribute> attributes) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            int dot;
            String annotation;
            if (!attr.isNavigable() && !attr.hasAssociationClass()) continue;
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)attr)) {
                output.write("    /**\n");
                output.write("     * " + attr.getDocumentation() + "\n");
                output.write("     */\n");
                output.write("");
            }
            if ((annotation = attr.getTagValue("annotation")) != null && annotation.length() > 0) {
                output.write("    " + annotation + "\n");
                output.write("");
            }
            String attrName = attr.getName();
            String attrVisibility = attr.getVisibility();
            String attrType = attr.getType();
            if (attr.hasAssociationClass()) {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                attrType = attr.getAssociationClass().getName();
            }
            if ((dot = attrType.lastIndexOf(".")) > -1) {
                attrType = attrType.substring(dot + 1);
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                attrType = this.getCollection(attr, attrType);
            }
            output.write("    " + attrVisibility + " " + attrType + " " + attrName + ";\n");
            output.write("");
        }
    }

    protected void generateGetters(Writer output, List<ObjectModelAttribute> attributes) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable()) continue;
            String attrName = attr.getName();
            String attrType = attr.getType();
            if (attr.hasAssociationClass()) {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                attrType = attr.getAssociationClass().getName();
            }
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            int dot = attrType.lastIndexOf(".");
            if (dot > -1) {
                attrType = attrType.substring(dot + 1);
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                attrType = this.getCollection(attr, attrType);
            }
            output.write("    public " + attrType + " get" + attrNameCapitalized + "() {\n");
            output.write("        return " + attrName + ";\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateSetters(Writer output, List<ObjectModelAttribute> attributes) throws IOException {
        for (ObjectModelAttribute attr : attributes) {
            if (!attr.isNavigable()) continue;
            String attrName = attr.getName();
            String attrType = attr.getType();
            if (attr.hasAssociationClass()) {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                attrName = GeneratorUtil.toLowerCaseFirstLetter((String)assocAttrName);
                attrType = attr.getAssociationClass().getName();
            }
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            int dot = attrType.lastIndexOf(".");
            if (dot > -1) {
                attrType = attrType.substring(dot + 1);
            }
            if (GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) {
                attrType = this.getCollection(attr, attrType);
            }
            output.write("    public void set" + attrNameCapitalized + "(" + attrType + " newValue) {\n");
            output.write("        " + attrType + " oldValue = get" + attrNameCapitalized + "();\n");
            output.write("        this." + attrName + " = newValue;\n");
            output.write("        firePropertyChange(\"" + attrName + "\", oldValue, newValue);\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateGetChild(Writer output, List<ObjectModelAttribute> multipleAttr) throws IOException {
        for (ObjectModelAttribute attr : multipleAttr) {
            String attrName = attr.getName();
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            String attrType = attr.getType();
            int dot = attrType.lastIndexOf(".");
            if (dot > -1) {
                attrType = attrType.substring(dot + 1);
            }
            ObjectModelClass attrEntity = null;
            if (((ObjectModel)this.model).hasClass(attr.getType())) {
                attrEntity = ((ObjectModel)this.model).getClass(attr.getType());
            }
            boolean isEntity = attrEntity != null && attrEntity.hasStereotype("entity");
            output.write("    public " + attrType + " get" + attrNameCapitalized + "(int index) {\n");
            output.write(" \t    " + attrType + " o = getChild(" + attrName + ", index);\n");
            output.write("        return o;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
            if (!isEntity) continue;
            output.write("    public " + attrType + " get" + attrNameCapitalized + "(String topiaId) {\n");
            output.write("        " + attrType + " o = getEntity(" + attrName + ", topiaId);\n");
            output.write("        return o;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateAddChild(Writer output, List<ObjectModelAttribute> multipleAttr) throws IOException {
        for (ObjectModelAttribute attr : multipleAttr) {
            String attrName = attr.getName();
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            String attrType = attr.getType();
            int dot = attrType.lastIndexOf(".");
            if (dot > -1) {
                attrType = attrType.substring(dot + 1);
            }
            output.write("    public " + attrType + " add" + attrNameCapitalized + "(" + attrType + " " + attrName + ") {\n");
            output.write(" \t    get" + attrNameCapitalized + "().add(" + attrName + ");\n");
            output.write("        firePropertyChange(\"" + attrName + "\", null, " + attrName + ");\n");
            output.write("        return " + attrName + ";\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateRemoveChild(Writer output, List<ObjectModelAttribute> multipleAttr) throws IOException {
        for (ObjectModelAttribute attr : multipleAttr) {
            String attrName = attr.getName();
            String attrNameCapitalized = StringUtils.capitalize((String)attrName);
            String attrType = attr.getType();
            int dot = attrType.lastIndexOf(".");
            if (dot > -1) {
                attrType = attrType.substring(dot + 1);
            }
            output.write("    public boolean remove" + attrNameCapitalized + "(" + attrType + " " + attrName + ") {\n");
            output.write("        boolean  removed = get" + attrNameCapitalized + "().remove(" + attrName + ");\n");
            output.write("        if (removed) {\n");
            output.write("            firePropertyChange(\"" + attrName + "\", " + attrName + ", null);\n");
            output.write("        }\n");
            output.write("        return removed;\n");
            output.write("    }\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateInterfaceOperations(Writer output, ObjectModelClassifier classifier) throws IOException {
        for (ObjectModelOperation op : classifier.getOperations()) {
            String opName = op.getName();
            output.write("    /**\n");
            output.write("");
            if (TopiaGeneratorUtil.hasDocumentation((ObjectModelElement)op)) {
                String opDocumentation = op.getDocumentation();
                output.write("     * " + opName + " : " + opDocumentation + "\n");
                output.write("");
            }
            Collection params = op.getParameters();
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramDocumentation = param.getDocumentation();
                output.write("     * @param " + paramName + " " + paramDocumentation + "\n");
                output.write(" ");
            }
            String opVisibility = op.getVisibility();
            String opType = op.getReturnType();
            output.write("     */\n");
            output.write("    " + opVisibility + " abstract " + opType + " " + opName + "(");
            String comma = "";
            for (ObjectModelParameter param : params) {
                String paramName = param.getName();
                String paramType = param.getType();
                output.write("" + comma + "" + paramType + " " + paramName + "");
                comma = ", ";
            }
            output.write(")");
            Set exceptions = op.getExceptions();
            comma = " throws ";
            for (String exception : exceptions) {
                output.write("" + comma + "" + exception + "");
                comma = ", ";
            }
            output.write(";\n");
            output.write("\n");
            output.write("");
        }
    }

    protected void generateToString(Writer output, ObjectModelClass clazz) throws IOException {
        output.write("\n");
        output.write("    @Override\n");
        output.write("    public String toString() {\n");
        output.write("        String result = new ToStringBuilder(this).\n");
        output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (!attr.isNavigable() && !attr.hasAssociationClass()) continue;
            String attrName = attr.getName();
            output.write("         append(\"" + attrName + "\", this." + attrName + ").\n");
            output.write("");
        }
        output.write("         toString();\n");
        output.write("        return result;\n");
        output.write("    }\n");
        output.write(" ");
    }

    protected String getCollection(ObjectModelAttribute attr, String attrType) {
        String nMultType = attr.isOrdered() ? "List<" : "Collection<";
        nMultType = nMultType + attrType;
        nMultType = nMultType + ">";
        return nMultType;
    }

    protected boolean isAbstract(ObjectModelClass clazz) {
        if (clazz.isAbstract()) {
            return true;
        }
        return !clazz.getOperations().isEmpty();
    }

    private List<ObjectModelAttribute> setAttributesForDTO(ObjectModelClass clazz, List<ObjectModelAttribute> attributes, ImportsManager imports) {
        if (clazz.hasStereotype("dto")) {
            if (log.isInfoEnabled()) {
                log.info((Object)"DTO dependency gestion");
            }
            for (ObjectModelDependency dependency : clazz.getDependencies()) {
                ObjectModelClass supplier = (ObjectModelClass)dependency.getSupplier();
                if (!supplier.hasStereotype("entity")) continue;
                if (log.isInfoEnabled()) {
                    log.info((Object)("Create primitive and date fields in DTO from Entity : " + supplier.getQualifiedName()));
                }
                for (ObjectModelAttribute attr : supplier.getAttributes()) {
                    if (TopiaGeneratorUtil.isPrimitiveType(attr) || TopiaGeneratorUtil.isDateType(attr)) {
                        attributes.add(attr);
                        imports.addImport(attr.getType());
                    }
                    if (!GeneratorUtil.isNMultiplicity((ObjectModelAttribute)attr)) continue;
                    imports.addImport("java.util.Collection");
                }
            }
        }
        return attributes;
    }
}

