/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

package org.nuiton.topia.persistence;

/**
 *
 * The contract of a visitor of any {@link TopiaEntity}.
 * 
 * Created: 28 janv. 2009 18:10:34
 *
 * @author poussin
 * @version $Revision$
 *
 * Last update: $Date$
 * by : $Author$
 */
public interface EntityVisitor {

    /**
     * Start the visit of the given entity.
     *
     * @param e the visited entity
     */
    void start(TopiaEntity e);

    /**
     * Ends the visit of the given entity.
     *
     * @param e the visited entity
     */
    void end(TopiaEntity e);

    /**
     * Visit a none indexed property for the given entity.
     *
     * The property visited is defined by the other parameters.
     *
     * @param e the visited entity
     * @param name the name of the visited property
     * @param type the type of the visited property
     * @param value the value of the visitied property
     */
    void visit(TopiaEntity e, String name, Class<?> type, Object value);

    /**
     * Visit a collection property for the given entity.
     *
     * The property visited is defined by the other parameters.
     *
     * @param e the visited entity
     * @param name the name of the visited property
     * @param collectionType  the type of the visited collection
     * @param type the type of the visited property
     * @param value the value of the visitied property
     */
    void visit(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, Object value);

    /**
     * Visit a indexed value from a collection property for the given entity.
     *
     * The property visited is defined by the other parameters.
     *
     * @param e the visited entity
     * @param name the name of the visited property
     * @param collectionType the type of the container of the visited property
     * @param type the type of the visited property
     * @param index the index of the visited property in his container
     * @param value the value of the visitied property
     */
    void visit(TopiaEntity e, String name, Class<?> collectionType, Class<?> type, int index, Object value);

    /**
     * reset all states of the visitor.
     */
    void clear();
}
