/* *##% ToPIA - Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*/

/* *
 * TopiaContextImplementor.java
 *
 * Created: 3 janv. 2006 21:27:24
 *
 * @author poussin
 * @version $Revision: 1593 $
 *
 * Last update: $Date: 2009-06-24 18:50:57 +0200 (mer., 24 juin 2009) $
 * by : $Author: tchemit $
 */
package org.nuiton.topia.framework;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaNotFoundException;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

/**
 * @author poussin
 *
 */
public interface TopiaContextImplementor extends TopiaContext {

    /**
     * @return Returns the childContext.
     */
    Set<TopiaContextImplementor> getChildContext();

    /**
     * @return Returns the parentContext.
     */
    TopiaContextImplementor getParentContext();

    TopiaContextImplementor getRootContext();

    /**
     * @return Returns the config.
     */
    Properties getConfig();

    /**
     * @return Returns the hibernate.
     * @throws TopiaException si aucune transaction n'est ouverte
     */
    Session getHibernate() throws TopiaException;

    /**
     * @return Returns the hibernateFactory.
     * @throws TopiaNotFoundException
     */
    SessionFactory getHibernateFactory() throws TopiaNotFoundException;

    /**
     * @return Returns the hibernate configuration
     * @throws TopiaNotFoundException
     */
    Configuration getHibernateConfiguration()
            throws TopiaNotFoundException;

    /**
     * Detect if the table is created on storage for a given persistant class.
     * 
     * @param clazz the researched class
     * @return Returns the hibernate.
     * @throws TopiaException si aucune transaction n'est ouverte
     */
    boolean isSchemaExist(Class<? extends TopiaEntity> clazz) throws TopiaException;

    /**
     * Get DAO for specified class. If Specialized DAO exists then it returned
     * otherwize TopiaDAO&lt;entityClass&gt; is returned
     * 
     * @param <E>
     * @param entityClass
     * @return a doa
     * @throws TopiaException 
     */
    <E extends TopiaEntity> TopiaDAO<E> getDAO(Class<E> entityClass)
            throws TopiaException;

    TopiaFiresSupport getFiresSupport();

    void removeChildContext(TopiaContextImplementor child);

    Map<String, TopiaService> getServices();

    Collection<TopiaService> getAllServices();

    List<Class<?>> getPersistenceClasses();
} //TopiaContextImplementor

