/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.config;

import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Properties;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigInit;
import org.nuiton.config.ArgumentsParserException;

public class SubApplicationConfig
extends ApplicationConfig {
    protected ApplicationConfig parent;
    protected String prefix;

    public SubApplicationConfig(ApplicationConfig parent, String prefix) {
        this.parent = parent;
        this.prefix = prefix;
    }

    @Override
    protected void init(ApplicationConfigInit init) {
    }

    public ApplicationConfig getParent() {
        return this.parent;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Properties getOptions() {
        return this.getParent().getOptions();
    }

    @Override
    public void setDefaultOption(String key, String value) {
        this.getParent().setDefaultOption(this.getPrefix() + key, value);
    }

    @Override
    public boolean hasOption(String key) {
        return this.getOption(key) != null;
    }

    @Override
    public void setOption(String key, String value) {
        this.getParent().setOption(this.getPrefix() + key, value);
    }

    @Override
    public String getOption(String key) {
        String result = this.getParent().getOption(this.getPrefix() + key);
        if (result == null) {
            result = this.getParent().getOption(key);
        }
        return result;
    }

    @Override
    public Properties getFlatOptions(boolean replaceInner) {
        Properties result = this.getParent().getFlatOptions(replaceInner);
        Properties tmp = new Properties();
        int lenght = this.getPrefix().length();
        for (Map.Entry<Object, Object> e : result.entrySet()) {
            String k = (String)e.getKey();
            if (!k.startsWith(this.getPrefix())) continue;
            k = k.substring(lenght);
            String v = (String)e.getValue();
            tmp.setProperty(k, v);
        }
        result.putAll((Map<?, ?>)tmp);
        return result;
    }

    @Override
    public Properties getOptionStartsWith(String prefix) {
        Properties result = this.getParent().getOptionStartsWith(prefix);
        Properties tmp = this.getParent().getOptionStartsWith(this.getPrefix() + prefix);
        int lenght = this.getPrefix().length();
        for (Map.Entry<Object, Object> e : tmp.entrySet()) {
            String k = (String)e.getKey();
            k = k.substring(lenght);
            String v = (String)e.getValue();
            result.setProperty(k, v);
        }
        return result;
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.startsWith(this.getPrefix())) {
            propertyName = propertyName.substring(this.getPrefix().length());
            this.getParent().firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getParent().addPropertyChangeListener(this.getPrefix() + propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getParent().removePropertyChangeListener(this.getPrefix() + propertyName, listener);
    }

    @Override
    public boolean hasListeners(String propertyName) {
        return this.getParent().hasListeners(this.getPrefix() + propertyName);
    }

    @Override
    public ApplicationConfig parse(String ... args) throws ArgumentsParserException {
        throw new UnsupportedOperationException("This method is not supported in SubApplicationConfig");
    }
}

