/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.math.matrix;

import org.nuiton.math.matrix.SparseVector;
import org.nuiton.math.matrix.VectorIterator;

public abstract class SparseVectorIterator
implements VectorIterator {
    protected boolean hasExclude = false;
    protected double exclude;
    protected SparseVector vector;
    protected int size;
    protected int assignedPos = 0;
    protected int assignedSize;
    protected double defaultValue;
    protected int pos = -1;
    protected int nextPos = -1;
    protected double value;
    protected double nextValue;

    public SparseVectorIterator(SparseVector vector) {
        this.vector = vector;
        this.size = vector.size();
        this.defaultValue = vector.getDefaultValue();
        this.assignedSize = vector.getNumberOfAssignedValue();
    }

    public SparseVectorIterator(SparseVector vector, double exclude) {
        this(vector);
        this.setExclude(exclude);
    }

    abstract int getAssignedPosition(int var1);

    abstract double getAssignedValues(int var1);

    @Override
    public void setExclude(double exclude) {
        this.hasExclude = true;
        this.exclude = exclude;
    }

    protected void computeNextPosAndValue() {
        if (this.nextPos <= this.pos) {
            if (this.hasExclude && this.exclude == this.defaultValue) {
                if (this.assignedPos < this.assignedSize) {
                    this.nextPos = this.getAssignedPosition(this.assignedPos);
                    this.nextValue = this.getAssignedValues(this.assignedPos);
                    ++this.assignedPos;
                } else {
                    this.nextPos = Integer.MAX_VALUE;
                }
            } else {
                do {
                    ++this.nextPos;
                    if (this.assignedPos < this.assignedSize - 1 && this.getAssignedPosition(this.assignedPos) < this.nextPos) {
                        ++this.assignedPos;
                    }
                    if (this.nextPos >= this.size) continue;
                    this.nextValue = this.getValue(this.nextPos);
                } while (this.nextPos < this.size && this.hasExclude && this.nextValue == this.exclude);
            }
        }
    }

    protected double getValue(int pos) {
        double result = this.defaultValue;
        if (this.assignedPos < this.assignedSize && pos == this.getAssignedPosition(this.assignedPos)) {
            result = this.getAssignedValues(this.assignedPos);
        }
        return result;
    }

    @Override
    public boolean hasNext() {
        this.computeNextPosAndValue();
        return this.nextPos < this.size;
    }

    @Override
    public double next() {
        this.computeNextPosAndValue();
        this.pos = this.nextPos;
        this.value = this.nextValue;
        return this.value;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
        this.vector.setValue(this.pos, value);
    }

    @Override
    public int getPosition() {
        return this.pos;
    }
}

