/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra.combobox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.jaxx.swing.extra.combobox.ComboBoxModel2;
import org.nuiton.jaxx.swing.extra.combobox.ComboBoxSelectionEvent;
import org.nuiton.jaxx.swing.extra.combobox.WillChangeSelectedItemListener;
import org.nuiton.jaxx.swing.extra.combobox.WillChangeSelectedItemVetoException;

public class JaxxDefaultComboBoxModel<E>
extends AbstractListModel
implements MutableComboBoxModel,
Serializable,
ComboBoxModel2 {
    private static final long serialVersionUID = 1L;
    protected List<E> delegate;
    protected E selectedObject;

    public JaxxDefaultComboBoxModel() {
        this.delegate = new ArrayList();
    }

    public JaxxDefaultComboBoxModel(E ... items) {
        this.delegate = new ArrayList(items.length);
        int c = items.length;
        for (int i = 0; i < c; ++i) {
            this.delegate.add(items[i]);
        }
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public JaxxDefaultComboBoxModel(Collection<E> v) {
        this.delegate = new ArrayList<E>(v);
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            try {
                this.fireSelectedItemWillChanged(this.selectedObject, anObject);
            }
            catch (WillChangeSelectedItemVetoException e) {
                return;
            }
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public int getIndexOf(E anObject) {
        return this.delegate.indexOf(anObject);
    }

    public void setAllElements(Collection<E> objects) {
        this.removeAllElements();
        this.addAllElements(objects);
    }

    public void addAllElements(Collection<E> objects) {
        if (CollectionUtils.isNotEmpty(objects)) {
            int firstIndex = this.delegate.size();
            this.delegate.addAll(objects);
            int lastIndex = this.delegate.size() - 1;
            if (lastIndex > -1) {
                this.fireIntervalAdded(this, firstIndex, lastIndex);
            }
        }
    }

    public void removeAllElements() {
        if (this.delegate.size() > 0) {
            int firstIndex = 0;
            int lastIndex = this.delegate.size() - 1;
            this.delegate.clear();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedObject = null;
        }
    }

    public E getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public int getSize() {
        return this.delegate.size();
    }

    @Override
    public E getElementAt(int index) {
        E result = index >= 0 && index < this.delegate.size() ? (E)this.delegate.get(index) : null;
        return result;
    }

    public void addElement(Object anObject) {
        this.delegate.add(anObject);
        this.fireIntervalAdded(this, this.delegate.size() - 1, this.delegate.size() - 1);
        if (this.delegate.size() == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void insertElementAt(Object anObject, int index) {
        this.delegate.add(index, anObject);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.delegate.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.delegate.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void addWillChangeSelectedItemListener(WillChangeSelectedItemListener l) {
        this.listenerList.add(WillChangeSelectedItemListener.class, l);
    }

    @Override
    public void removeWillChangeSelectedItemListener(WillChangeSelectedItemListener l) {
        this.listenerList.remove(WillChangeSelectedItemListener.class, l);
    }

    public void fireSelectedItemWillChanged(Object currentSelectedItem, Object newSelectedItem) throws WillChangeSelectedItemVetoException {
        Object[] listeners = this.listenerList.getListenerList();
        ComboBoxSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WillChangeSelectedItemListener.class) continue;
            if (e == null) {
                e = new ComboBoxSelectionEvent(this, (Serializable)currentSelectedItem, (Serializable)newSelectedItem);
            }
            ((WillChangeSelectedItemListener)listeners[i + 1]).selectedItemWillChanged(e);
        }
    }
}

