/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra;

import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTrees {
    private static final Log log = LogFactory.getLog(JTrees.class);

    public static void expandTree(final JTree tree) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < tree.getRowCount()) {
                    tree.expandRow(i++);
                }
            }
        });
    }

    public static void addExpandOnClickListener(final JTree tree) {
        tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(final TreeSelectionEvent e) {
                TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                if (node != null && !node.isLeaf()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            for (TreePath path : e.getPaths()) {
                                if (!e.isAddedPath(path) || tree.isExpanded(path)) continue;
                                log.info((Object)("expand node [" + path + "]"));
                                tree.expandPath(path);
                            }
                        }
                    });
                }
            }
        });
    }
}

