/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.swing.extra;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class Desktops {
    private static final Log log = LogFactory.getLog(Desktops.class);

    public static void openLink(HyperlinkEvent he) {
        block6: {
            if (he.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    URL u = he.getURL();
                    if (u.getProtocol().equalsIgnoreCase("mailto") || u.getProtocol().equalsIgnoreCase("http") || u.getProtocol().equalsIgnoreCase("ftp")) {
                        Desktop.getDesktop().browse(u.toURI());
                    }
                }
                catch (IOException e) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while opening link", (Throwable)e);
                    }
                }
                catch (URISyntaxException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Error while opening link", (Throwable)e);
                }
            }
        }
    }

    public static void openLink(String url) {
        block4: {
            try {
                if (!Desktop.isDesktopSupported()) {
                    throw new IllegalStateException(I18n.t((String)"swing.error.desktop.not.supported", (Object[])new Object[0]));
                }
                Desktop desktop = Desktop.getDesktop();
                if (!desktop.isSupported(Desktop.Action.BROWSE)) {
                    throw new IllegalStateException(I18n.t((String)"swing.error.desktop.browse.not.supported", (Object[])new Object[0]));
                }
                URI uri = new URI(url);
                desktop.browse(uri);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Error while opening link", (Throwable)e);
            }
        }
    }

    public static void openLink(URI uri) {
        Desktop desktop = Desktops.getDesktopForBrowse();
        try {
            desktop.browse(uri);
        }
        catch (Exception e) {
            throw new RuntimeException(I18n.t((String)"application.error.cannot.open.link", (Object[])new Object[]{uri}), e);
        }
    }

    public static Desktop getDesktopForBrowse() {
        if (!Desktop.isDesktopSupported()) {
            throw new RuntimeException(I18n.t((String)"application.error.desktop.not.supported", (Object[])new Object[0]));
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            throw new RuntimeException(I18n.t((String)"application.error.desktop.browse.not.supported", (Object[])new Object[0]));
        }
        return desktop;
    }

    public static void copyToClipBoard(String text) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (log.isInfoEnabled()) {
            log.info((Object)("Put in clipboard :\n" + text));
        }
        StringSelection selection = new StringSelection(text);
        clipboard.setContents(selection, selection);
    }
}

