/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.util;

import org.nuiton.jaxx.util.DialogUIDef;

public abstract class UIProvider {
    protected String applicationName;
    protected String providerName;
    protected Class<?>[] implementations;

    protected UIProvider(String applicationName, String providerName, Class<?> ... implementations) {
        this.applicationName = applicationName;
        this.providerName = providerName;
        this.implementations = implementations;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Class<?>[] getImplementations() {
        return this.implementations;
    }

    public Class<?> findUIImplementation(DialogUIDef<?, ?, ?> def) {
        Class<?> uiClass = def.getUiClass();
        for (Class<?> klass : this.implementations) {
            if (!uiClass.isAssignableFrom(klass)) continue;
            def.setUiImplClass(klass);
            return klass;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append('<');
        sb.append(this.printClass("application", this.applicationName, true));
        sb.append(this.printClass("provider", this.providerName, true));
        sb.append(this.printClass("uis", this.implementations.length, false));
        return sb.toString();
    }

    protected String printClass(String s, Object aClass, boolean notLast) {
        return s + ':' + (aClass == null ? null : aClass) + (notLast ? ", " : ">");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UIProvider)) {
            return false;
        }
        UIProvider that = (UIProvider)o;
        return this.applicationName.equals(that.applicationName) && this.providerName.equals(that.providerName);
    }

    public int hashCode() {
        return 31 * this.applicationName.hashCode() + this.providerName.hashCode();
    }
}

