/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.nuiton.jaxx.runtime.api.swing.Item;

public class JAXXTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private static final String SYNTHETIC = "<synthetic root node>";

    public JAXXTree(TreeModel model) {
        super(model);
    }

    public JAXXTree() {
        this.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String label;
                Item item;
                TreeModel model = tree.getModel();
                if (model instanceof JAXXTreeModel && (item = ((JAXXTreeModel)model).findItem(value)) != null && (label = item.getLabel()) != null) {
                    value = label;
                }
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeModel model = JAXXTree.this.getModel();
                if (model instanceof JAXXTreeModel) {
                    this.scan((JAXXTreeModel)model, ((JAXXTreeModel)model).root);
                }
            }

            private void scan(JAXXTreeModel model, Item item) {
                TreePath path = model.getTreePath(item);
                if (item.isSelected() != JAXXTree.this.isPathSelected(path)) {
                    item.setSelected(!item.isSelected());
                }
                List<Item> children = item.getChildren();
                for (Item aChildren : children) {
                    this.scan(model, aChildren);
                }
            }
        });
    }

    public void setItem(Item items) {
        ArrayList<Item> newItems = new ArrayList<Item>();
        newItems.add(items);
        this.setItems(newItems);
    }

    public void setItems(List<Item> items) {
        JAXXTreeModel model = new JAXXTreeModel(items);
        if (model.getRoot() != null) {
            this.setRootVisible(model.getRoot() != SYNTHETIC);
        }
        this.setModel(model);
        if (items != null) {
            ArrayList<TreePath> treePathSelected = new ArrayList<TreePath>();
            for (Item i : items) {
                if (!i.isSelected()) continue;
                treePathSelected.add(model.getTreePath(i));
            }
            this.setSelectionPaths(this.convertToTreePathArray(treePathSelected.toArray()));
        }
    }

    public Object getSelectionValue() {
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? selectionPath.getLastPathComponent() : null;
    }

    public Item getRootItem() {
        if (this.getModel() instanceof JAXXTreeModel) {
            return ((JAXXTreeModel)this.getModel()).getRootItem();
        }
        return null;
    }

    protected TreePath[] convertToTreePathArray(Object[] datas) {
        TreePath[] params = new TreePath[datas.length];
        System.arraycopy(datas, 0, params, 0, datas.length);
        return params;
    }

    public class JAXXTreeModel
    implements TreeModel {
        private Item root;
        private List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();

        public JAXXTreeModel(List<Item> items) {
            if (items.size() == 1) {
                this.root = items.get(0);
            } else {
                this.root = new Item(null, null, JAXXTree.SYNTHETIC, false);
                for (Item item : items) {
                    this.root.addChild(item);
                }
            }
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("selected")) {
                        Item item = (Item)e.getSource();
                        if (item.isSelected()) {
                            JAXXTree.this.addSelectionPath(JAXXTreeModel.this.getTreePath(item));
                        } else {
                            JAXXTree.this.removeSelectionPath(JAXXTreeModel.this.getTreePath(item));
                        }
                    } else {
                        int[] nArray;
                        TreePath path;
                        Item item = (Item)e.getSource();
                        boolean root = item.getParent() == null;
                        TreePath treePath = path = !root ? JAXXTreeModel.this.getTreePath(item.getParent()) : null;
                        if (!root) {
                            int[] nArray2 = new int[1];
                            nArray = nArray2;
                            nArray2[0] = item.getParent().getChildren().indexOf(item);
                        } else {
                            nArray = null;
                        }
                        JAXXTreeModel.this.fireTreeNodesChanged(new TreeModelEvent((Object)JAXXTreeModel.this, path, nArray, new Object[]{item.getValue()}));
                    }
                }
            };
            this.addPropertyChangeListener(this.root, listener);
        }

        private void addPropertyChangeListener(Item item, PropertyChangeListener listener) {
            item.addPropertyChangeListener(listener);
            List<Item> children = item.getChildren();
            for (Item aChildren : children) {
                this.addPropertyChangeListener(aChildren, listener);
            }
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            this.listeners.add(listener);
        }

        public Item findItem(Object value) {
            return this.findItem(this.root, value);
        }

        private Item findItem(Item node, Object value) {
            if (node.getValue() == value) {
                return node;
            }
            List<Item> children = node.getChildren();
            for (Item aChildren : children) {
                Item result = this.findItem(aChildren, value);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        private TreePath getTreePath(Item node) {
            ArrayList<Object> path = new ArrayList<Object>();
            while (node != null) {
                path.add(0, node.getValue());
                node = node.getParent();
            }
            return new TreePath(path.toArray());
        }

        @Override
        public Object getChild(Object parent, int index) {
            Item node = this.findItem(parent);
            return node.getChildren().get(index).getValue();
        }

        @Override
        public int getChildCount(Object parent) {
            Item node = this.findItem(parent);
            if (node == null) {
                return 0;
            }
            return node.getChildren().size();
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            Item node = this.findItem(parent);
            List<Item> children = node.getChildren();
            int j = children.size();
            for (int i = 0; i < j; ++i) {
                if (children.get(i).getValue() != child) continue;
                return i;
            }
            return -1;
        }

        @Override
        public Object getRoot() {
            return this.root.getValue();
        }

        public Item getRootItem() {
            return this.root;
        }

        @Override
        public boolean isLeaf(Object node) {
            Item item = this.findItem(node);
            return item != null && item.getChildren().size() == 0;
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            this.listeners.remove(listener);
        }

        public void fireTreeNodesChanged(TreeModelEvent e) {
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesChanged(e);
            }
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }
}

