package org.nuiton.jaxx.runtime.api.swing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.runtime.api.JAXXObject;

import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class JLayers {

    /** Logger. */
    private static final Log log = LogFactory.getLog(JLayers.class);

    /**
     * Box a component in a {@link JLayer}.
     *
     * @param component the component to box
     * @return the {@link JLayer} boxing the component
     */
    public static <V extends Component> JLayer<V> boxComponentWithJLayer(V component) {
        JLayer<V> layer = getLayer(component);
        if (layer == null) {
            layer = new JLayer<>();
            layer.setView(component);
        }
        return layer;
    }

    public static List<Component> getLayeredComponents(JAXXObject object) {
        List<Component> result = new ArrayList<>();
        for (Map.Entry<String, Object> child : object.get$objectMap().entrySet()) {
            if (child.getValue() == null) {
                log.warn("find a null object in $objectMap " + child.getKey());
                continue;
            }
            if (JComponent.class.isAssignableFrom(child.getValue().getClass())) {
                JComponent comp = (JComponent) child.getValue();
                if (isLayered(comp)) {
                    result.add(comp);
                }
            }
        }
        return result;
    }

    public static <V extends Component> JLayer<V> getLayer(V comp) {
        if (!isLayered(comp)) {
            return null;
        }
        return (JLayer<V>) comp.getParent();
    }

    public static <V extends Component> void setLayerUI(Component comp, LayerUI<V> ui) {
        JLayer<V> layer = (JLayer<V>) getLayer(comp);
        if (layer != null) {
            layer.setUI(ui);
        }
    }

    public static boolean isLayered(Component comp) {
        Container parent = comp.getParent();
        return parent != null && parent instanceof JLayer<?>;
    }

}
