package jaxx.demo.component.swing;

/*
 * #%L
 * JAXX :: Demo
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2008 - 2013 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JSliderDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JPANEL0_BACKGROUND = "$JPanel0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRR+LWxL+SFCFVExAYVEY7L14MVAEIQQJFWMTQixF2e7k+7g7uw4OwurB+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s93+kqU00sNu++Z733zvzfemb3+AEUiY2yNRZMqQK+ZRc2t1d3fb2qM1tU6DmmRC+RIan0wWslUYsVvxQMGValmnl5L00prvCZ9T3pG9WIbhQD1zaeBQqhRc6s6oBUGp0lpejEQom6wtUWmsr3/9zL6yX77JAkQC1eWxlNnjstqVDJYhy2wFk7jTPim5hNdRhmS8jnrHdGzNJUFwn3j0KbyAfBlygkgkU3C5/5Jjjjg/EgpG5tep5z8gnLo3FCzEYm2MmLUmhRkcoAJzq+Iym0qNFiLOzynIzW/e8SNMPNdVZSNDL2lcoQO+czR8J4GPtuADkmI3irrwqFuFBoy3cEZdUsr1jzPdC4OWG9KU+ND8VrPiyS72OJqIkHCxSyWawmybon1qmSoYMsSwgunqYR89xKWGg6b/cZAmjFf/TBW/fvj+fqNpm1Hc+2wqtMP1eJxC+oJKxfTW4w3PhIq5pXtELFahEFAXRyYeiZkUYZVkGcXhfhM63dTp5iYJHKQw8t8+fpp6/GUAshsw7PrE3iAafxcKypHYBd+1I3F7JVY0ejCEz9NaG56Y40v23OeKuKsuq3MvtujkEuMu43SWKPS0FSq6HGFXZlK60pJmFT7/LlberTQ7k0Gl54+Et7tjPIJcY7d4pJJpSR2hERHQ0PbbU5E2Jxn9HhOJ8efi50Ja6RP7+kBqHYVr6NUo1K9rcQX62/W+CfMeiZgXej1oin3QGPskGYX/JtHhmz0YpvpiuHVihl4apk+s4XgGBcMWqT2pSz/keD2dWrKJIrMW4zZeIcvprBf6YM1Zvkyutu0TsDiU1Z1eruuHxTjA/yHnGJK/JsbTaawHAAA=";
    private static final Log log = LogFactory.getLog(JSliderDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JSlider blue;
    protected JSlider green;
    protected JSlider red;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSliderDemo $DemoPanel0 = this;
    private HBox $HBox0;
    private JPanel $JPanel0;
    private VBox $VBox0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSliderDemo() {
        $initialize();
    }

    public JSliderDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public JSliderDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public JSliderDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JSliderDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public JSliderDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JSliderDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public JSliderDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JSlider getBlue() {
        return blue;
    }

    public JSlider getGreen() {
        return green;
    }

    public JSlider getRed() {
        return red;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected HBox get$HBox0() {
        return $HBox0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected VBox get$VBox0() {
        return $VBox0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBlue() {
        $objectMap.put("blue", blue = new JSlider());
        
        blue.setName("blue");
        blue.setValue(0);
        blue.setMaximum(255);
        blue.setValue(240);
    }

    protected void createGreen() {
        $objectMap.put("green", green = new JSlider());
        
        green.setName("green");
        green.setValue(0);
        green.setMaximum(255);
        green.setValue(180);
    }

    protected void createRed() {
        $objectMap.put("red", red = new JSlider());
        
        red.setName("red");
        red.setValue(0);
        red.setMaximum(255);
        red.setValue(200);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add($VBox0);
        $HBox0.add($JPanel0);
        // inline complete setup of $VBox0
        $VBox0.add(red);
        $VBox0.add(green);
        $VBox0.add(blue);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JPanel0.setBorder(BorderFactory.createEtchedBorder());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new VBox());
        
        $VBox0.setName("$VBox0");
        createRed();
        createGreen();
        createBlue();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,64);
        SwingUtil.setComponentWidth($JPanel0,64);
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JPANEL0_BACKGROUND, true, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red.getModel()", red.getModel());
                    red.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    red.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (green != null) {
                    $bindingSources.put("green.getModel()", green.getModel());
                    green.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    green.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (blue != null) {
                    $bindingSources.put("blue.getModel()", blue.getModel());
                    blue.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    blue.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red != null && blue != null && green != null) {
                    $JPanel0.setBackground(new Color(red.getValue(), green.getValue(), blue.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("red.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    red.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (green != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("green.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    green.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (blue != null) {
                    BoundedRangeModel $target = (BoundedRangeModel) $bindingSources.remove("blue.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    blue.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}