/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.component.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.component.swing.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class JSliderDemo extends jaxx.demo.DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JPANEL0_BACKGROUND = "$JPanel0.background";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRR+LWxL+SFCFVExAYVEY7L14MVAEIQQJFWMTQixF2e7k+7g7uw4OwurB+Of4J+gdy8m3jwZD549eDH+C8Z48Gp8s93+kqU00sNu++Z733zvzfemb3+AEUiY2yNRZMqQK+ZRc2t1d3fb2qM1tU6DmmRC+RIan0wWslUYsVvxQMGValmnl5L00prvCZ9T3pG9WIbhQD1zaeBQqhRc6s6oBUGp0lpejEQom6wtUWmsr3/9zL6yX77JAkQC1eWxlNnjstqVDJYhy2wFk7jTPim5hNdRhmS8jnrHdGzNJUFwn3j0KbyAfBlygkgkU3C5/5Jjjjg/EgpG5tep5z8gnLo3FCzEYm2MmLUmhRkcoAJzq+Iym0qNFiLOzynIzW/e8SNMPNdVZSNDL2lcoQO+czR8J4GPtuADkmI3irrwqFuFBoy3cEZdUsr1jzPdC4OWG9KU+ND8VrPiyS72OJqIkHCxSyWawmybon1qmSoYMsSwgunqYR89xKWGg6b/cZAmjFf/TBW/fvj+fqNpm1Hc+2wqtMP1eJxC+oJKxfTW4w3PhIq5pXtELFahEFAXRyYeiZkUYZVkGcXhfhM63dTp5iYJHKQw8t8+fpp6/GUAshsw7PrE3iAafxcKypHYBd+1I3F7JVY0ejCEz9NaG56Y40v23OeKuKsuq3MvtujkEuMu43SWKPS0FSq6HGFXZlK60pJmFT7/LlberTQ7k0Gl54+Et7tjPIJcY7d4pJJpSR2hERHQ0PbbU5E2Jxn9HhOJ8efi50Ja6RP7+kBqHYVr6NUo1K9rcQX62/W+CfMeiZgXej1oin3QGPskGYX/JtHhmz0YpvpiuHVihl4apk+s4XgGBcMWqT2pSz/keD2dWrKJIrMW4zZeIcvprBf6YM1Zvkyutu0TsDiU1Z1eruuHxTjA/yHnGJK/JsbTaawHAAA=";
    private static final Log log = LogFactory.getLog(jaxx.demo.component.swing.JSliderDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JSlider blue;
    protected javax.swing.JSlider green;
    protected javax.swing.JSlider red;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JSliderDemo $DemoPanel0 = this;
    private jaxx.runtime.swing.HBox $HBox0;
    private jaxx.runtime.swing.VBox $VBox0;
    private javax.swing.JPanel $JPanel0;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public JSliderDemo() {
        super();
        $initialize();
    }

    public JSliderDemo(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JSlider getBlue() {
        return blue;
    }

    public javax.swing.JSlider getGreen() {
        return green;
    }

    public javax.swing.JSlider getRed() {
        return red;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.HBox get$HBox0() {
        return $HBox0;
    }

    protected jaxx.runtime.swing.VBox get$VBox0() {
        return $VBox0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBlue() {
        $objectMap.put("blue", blue = new javax.swing.JSlider());
        
        blue.setName("blue");
        blue.setValue(0);
        blue.setMaximum(255);
        blue.setValue(240);
    }

    protected void createGreen() {
        $objectMap.put("green", green = new javax.swing.JSlider());
        
        green.setName("green");
        green.setValue(0);
        green.setMaximum(255);
        green.setValue(180);
    }

    protected void createRed() {
        $objectMap.put("red", red = new javax.swing.JSlider());
        
        red.setName("red");
        red.setValue(0);
        red.setMaximum(255);
        red.setValue(200);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $DemoPanel0
        add($HBox0);
        // inline complete setup of $HBox0
        $HBox0.add($VBox0);
        $HBox0.add($JPanel0);
        // inline complete setup of $VBox0
        $VBox0.add(red);
        $VBox0.add(green);
        $VBox0.add(blue);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 1 property setters
        $JPanel0.setBorder(BorderFactory.createEtchedBorder());
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$DemoPanel0", this);
        // inline creation of $HBox0
        $objectMap.put("$HBox0", $HBox0 = new jaxx.runtime.swing.HBox());
        
        $HBox0.setName("$HBox0");
        $HBox0.setHorizontalAlignment(0);
        $HBox0.setVerticalAlignment(0);
        // inline creation of $VBox0
        $objectMap.put("$VBox0", $VBox0 = new jaxx.runtime.swing.VBox());
        
        $VBox0.setName("$VBox0");
        createRed();
        createGreen();
        createBlue();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        SwingUtil.setComponentHeight($JPanel0,64);
        SwingUtil.setComponentWidth($JPanel0,64);
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JPANEL0_BACKGROUND, true) {
        
            @Override
            public void applyDataBinding() {
                if (red != null) {
                    $bindingSources.put("red.getModel()", red.getModel());
                    red.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    red.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (green != null) {
                    $bindingSources.put("green.getModel()", green.getModel());
                    green.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    green.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (blue != null) {
                    $bindingSources.put("blue.getModel()", blue.getModel());
                    blue.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    blue.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (red != null && blue != null && green != null) {
                    $JPanel0.setBackground(new Color(red.getValue(), green.getValue(), blue.getValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (red != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("red.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    red.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (green != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("green.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    green.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
                if (blue != null) {
                    javax.swing.BoundedRangeModel $target = ((javax.swing.BoundedRangeModel) $bindingSources.remove("blue.getModel()"));
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    blue.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.swing.JSliderDemo.this, BINDING_$JPANEL0_BACKGROUND));
                }
            }
        
            public void $pr$u0(javax.swing.event.ChangeEvent event) {
                propertyChange(null);
            }
        });
    }

}