/*
 * #%L
 * JAXX :: Demo
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.demo.feature.nav.content;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.demo.entities.*;
import jaxx.demo.feature.nav.content.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class ActorContentUI extends jaxx.demo.feature.nav.content.AbstractContentUI<People> {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_DATA = "data";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_ICON = "$JLabel0.icon";
    private static final String BINDING_$JTEXT_PANE0_TEXT = "$JTextPane0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTU8TQRieVlooBcFWCg2YIDYmGtzKuUSpCJGmKrEYib04uzu0Q2Z3x9lZWDgYf4I/Qe9eTLx5Mh48e/Bi/AvGePBqfGfbbq2upbHuodvM+z7PPO/H0778ghKuQOf3se9rwrMltYhWKe/u3tX3iSFvEtcQlEtHoNYTi6N4HaXN8NyV6EK9quDFNry47ljcsYn9C7pUReOuPGLEbRIiJTrXizBct1gLwyWfe6LDGoqKYn3+7Wv8mfn0RRwhn4O6UShl8SRUt5KRKopTU6IM3HSAiwzbDZAhqN0AvZPqbJ1h172DLfIYPUGjVZTkWACZREuDlxxwBHifS5QtlHVXCmzIdceWgLi/dVWi5UC0SSxH2yNYeoJoNj7QjFaKVjaAMMznPKBLSjRiYoklynfRkEAlJa62TRzOSDc15XJG5Ta2iUQ5VZqvuYdQqVapdQIqMxUCJguVmiEcxlQIJM72gsKQSp8KUelCZYf4so2Z6cF0Aio1E33Pijo820s5VqhUsU4Y8GV6+IJTlTTHYe7zPXOHjdK6G9UdeayOEsKDY4nm6n8u4T0ItdZv7rf1U4RB9Ecu+/HN59ebnZ2bhrtnIlN/sQzsAhcOJ0LNRqKp1sJ5krLibcxLdRgPYcRo+WkhQlitHQZxcN8ZBdcUXLuF3SZQJEY/vX2Xe/ThFIpvonHmYHMTq/wtlJJNAV1wmOnz62uBoonDMSVcaYOewt7uOJ7R3PA5tk2sM+hXZpXajNpkEUvwg+5Jcs2HpixENCVUpqfef8/WXq11GhMDofm/pnebk3iIkq3bAju2nRZpvzR3iWc6XUdFeSym3tO8vfpLwefFqMrTjqDgFywpOAudXlVmWtSpbcJ2QbkKdzmoQ31bHph2AtpNj8kDQhtNqbIu/TtXUneESYSKr0SzZAdgyTeh0mMoErOW1W5gse0wahwNSTx7oDba+L+06rjUhyE3gLAxYlKpVrlP/wfhSe1B166ocQ5JNCLhx2+ook5qS34ghrWhGMAzFrWp5Vm1dkuGErMxpJhsd6/LjDZsC9zcZ07zg8yJwn9uH1mK4yfLSnuTNAkAAA==";
    private static final Log log = LogFactory.getLog(jaxx.demo.feature.nav.content.ActorContentUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;
    private boolean contextInitialized = true;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.demo.entities.People data;
    protected javax.swing.JSplitPane splitPane;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private ActorContentUI $AbstractContentUI0 = this;
    private javax.swing.JScrollPane $JScrollPane0;
    private javax.swing.JTextPane $JTextPane0;
    private javax.swing.JScrollPane $JScrollPane1;
    private javax.swing.JLabel $JLabel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    String getContent(People data) {
       if (data == null) {
           return "no content";
       }
       StringBuilder buffer = new StringBuilder();
       buffer.append(data);
       return buffer.toString();
    }
    
    ImageIcon getImage(People data) {
        return data == null? null :SwingUtil.createIcon(data.getImage());
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public ActorContentUI() {
        super();
        $initialize();
    }

    public ActorContentUI(JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public jaxx.demo.entities.People getData() {
        return data;
    }

    public javax.swing.JSplitPane getSplitPane() {
        return splitPane;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setData(jaxx.demo.entities.People newValue) {
        jaxx.demo.entities.People oldValue = this.data;
        this.data = newValue;
        firePropertyChange(PROPERTY_DATA, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected javax.swing.JTextPane get$JTextPane0() {
        return $JTextPane0;
    }

    protected javax.swing.JScrollPane get$JScrollPane1() {
        return $JScrollPane1;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JScrollPane0, JSplitPane.LEFT);
        splitPane.add($JScrollPane1, JSplitPane.RIGHT);
    }

    protected void createData() {
        $objectMap.put("data", data = null);
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new javax.swing.JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.5);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $AbstractContentUI0
        add(splitPane, BorderLayout.CENTER);
        addChildrenToSplitPane();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add($JTextPane0);
        // inline complete setup of $JScrollPane1
        $JScrollPane1.getViewport().add($JLabel0);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 9 property setters
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        $JScrollPane0.setBorder(null);
        $JScrollPane0.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        $JScrollPane0.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        $JTextPane0.setBorder(new TitledBorder(_("jaxxdemo.navigation.actor.title")));
        $JScrollPane1.setBorder(new TitledBorder("Picture"));
        $JScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        $JScrollPane1.setMinimumSize(SwingUtil.newMinDimension());
        $JScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$AbstractContentUI0", this);
        createData();
        createSplitPane();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        // inline creation of $JTextPane0
        $objectMap.put("$JTextPane0", $JTextPane0 = new javax.swing.JTextPane());
        
        $JTextPane0.setName("$JTextPane0");
        $JTextPane0.setEditable(false);
        if ($JTextPane0.getFont() != null) {
            $JTextPane0.setFont($JTextPane0.getFont().deriveFont((float) 11));
        }
        // inline creation of $JScrollPane1
        $objectMap.put("$JScrollPane1", $JScrollPane1 = new javax.swing.JScrollPane());
        
        $JScrollPane1.setName("$JScrollPane1");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setHorizontalAlignment(0);
        // inline creation of $AbstractContentUI0
        setName("$AbstractContentUI0");
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JTEXT_PANE0_TEXT, true ,"data") {
        
            @Override
            public void processDataBinding() {
                jaxx.runtime.SwingUtil.setText($JTextPane0, getContent(getData()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_ICON, true ,"data") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setIcon(getImage(getData()));
            }
        });
    }

}