/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.compiler.java;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.extension.ImportsManager;
import org.nuiton.jaxx.compiler.java.JavaArgument;
import org.nuiton.jaxx.compiler.java.JavaConstructor;
import org.nuiton.jaxx.compiler.java.JavaElement;
import org.nuiton.jaxx.compiler.java.JavaElementFactory;
import org.nuiton.jaxx.compiler.java.JavaField;
import org.nuiton.jaxx.compiler.java.JavaMethod;
import org.nuiton.jaxx.compiler.types.TypeManager;

public class JavaFile
extends JavaElement {
    static final Log log = LogFactory.getLog(JavaFile.class);
    protected static final String GETTER_PATTERN = "return %1$s;";
    protected static final String BOOLEAN_GETTER_PATTERN = "return %1$s !=null && %1$s;";
    protected static final String SETTER_PATTERN = "%1$s oldValue = this.%2$s;\nthis.%2$s = %2$s;\nfirePropertyChange(%3$s, oldValue, %2$s);";
    private Set<String> imports = new HashSet<String>();
    private List<JavaField> fields = new ArrayList<JavaField>();
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private List<JavaConstructor> constructors = new ArrayList<JavaConstructor>();
    private final List<JavaFile> innerClasses = new ArrayList<JavaFile>();
    private String superClass;
    private List<String> interfaces;
    private final StringBuilder rawBodyCode = new StringBuilder();
    private boolean superclassIsJAXXObject;
    private boolean abstractClass;
    private String genericType;
    private String superGenericType;
    private final ImportsManager importManager = new ImportsManager();
    private String simpleName;

    JavaFile(int modifiers, String className) {
        super(modifiers, className);
        this.importManager.addImport(className);
    }

    @Deprecated
    JavaFile() {
        this(0, "");
    }

    @Deprecated
    JavaFile(int modifiers, String className, String superClass) {
        this(modifiers, className, superClass, null);
    }

    @Deprecated
    JavaFile(int modifiers, String className, String superClass, List<String> interfaces) {
        this(modifiers, className);
        this.setSuperClass(superClass);
        if (CollectionUtils.isNotEmpty(interfaces)) {
            this.addInterface(interfaces.toArray(new String[interfaces.size()]));
        }
    }

    public String getPackageName() {
        String name = this.getName();
        String packageName = name.contains(".") ? name.substring(0, name.lastIndexOf(".")) : null;
        return packageName;
    }

    public ImportsManager getImportManager() {
        return this.importManager;
    }

    public String getImportedType(Class<?> type) {
        return this.getImportManager().getType(type);
    }

    public String getImportedType(String type) {
        return this.getImportManager().getType(type);
    }

    public String[] getImports() {
        ArrayList<String> result = new ArrayList<String>(this.imports);
        Collections.sort(result);
        return result.toArray(new String[result.size()]);
    }

    public List<String> getImportsList() {
        ArrayList<String> result = new ArrayList<String>(this.imports);
        Collections.sort(result);
        return result;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public List<String> getInterfaces() {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList<String>();
        }
        return this.interfaces;
    }

    public List<JavaMethod> getMethods() {
        return this.methods;
    }

    public List<JavaField> getFields() {
        return this.fields;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public String getGenericType() {
        return this.genericType;
    }

    public List<JavaFile> getInnerClasses() {
        return this.innerClasses;
    }

    public StringBuilder getRawBodyCode() {
        return this.rawBodyCode;
    }

    public String getSuperGenericType() {
        return this.superGenericType;
    }

    public boolean isSuperclassIsJAXXObject() {
        return this.superclassIsJAXXObject;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public JavaField getField(String componentId) {
        for (JavaField field : this.fields) {
            if (!componentId.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public void addImport(String importString) {
        try {
            this.importManager.addImport(importString);
        }
        catch (Exception e) {
            log.error((Object)("Could not determine simple name of import " + importString));
        }
    }

    public void addImport(Class<?> importString) {
        this.addImport(importString.getName());
    }

    public void setImports(Collection<String> imports) {
        this.imports = new HashSet<String>(imports);
    }

    public void setGenericType(String genericType) {
        this.genericType = genericType;
    }

    public void setSuperClass(String superClass) {
        this.superClass = superClass;
    }

    public void addInterface(String ... canonicalNames) {
        if (canonicalNames == null) {
            return;
        }
        for (String canonicalName : canonicalNames) {
            if (this.interfaces != null && this.interfaces.contains(canonicalName)) continue;
            this.getInterfaces().add(canonicalName);
        }
    }

    public void setInterfaces(List<String> interfaces) {
        ArrayList<String> simpleInterfaces = new ArrayList<String>();
        for (String anInterface : interfaces) {
            try {
                anInterface = this.importManager.getType(anInterface);
            }
            catch (Exception e) {
                log.error((Object)("Could not determine simple name of interface " + anInterface));
            }
            simpleInterfaces.add(anInterface);
        }
        this.interfaces = simpleInterfaces;
    }

    public void addConstructor(JavaConstructor constructor) {
        this.constructors.add(constructor);
    }

    public void addMethod(JavaMethod method) {
        String returnType = method.getReturnType();
        try {
            String type = this.importManager.getReturnType(returnType);
            method.setReturnType(type);
        }
        catch (Exception e) {
            log.error((Object)("Could not determine simple name of return type " + returnType + " for method " + method.getName()));
        }
        for (JavaArgument argument : method.getArguments()) {
            String argumentType = argument.getType();
            try {
                String type = this.importManager.getType(argumentType);
                argument.setType(type);
            }
            catch (Exception e) {
                log.error((Object)("Could not determine simple name of argument type " + argumentType + " of argument " + argument.getName() + " for method " + method.getName()));
            }
        }
        for (String exception : method.getExceptions()) {
            try {
                String exceptionSimple;
                exceptions[i] = exceptionSimple = this.importManager.getType(exception);
            }
            catch (Exception e) {
                log.error((Object)("Could not determine simple name of exception " + exception + " for method " + method.getName()));
            }
        }
        this.methods.add(method);
    }

    public void addField(JavaField field) {
        this.addField(field, false);
    }

    public JavaMethod addGetterMethod(String id, int modifiers, String type, boolean overridde, boolean useOverride) {
        String capitalizedName = StringUtils.capitalize((String)id);
        String methodName = "get" + capitalizedName;
        String bodyCode = useOverride ? "super." + methodName + "()" : id;
        String content = String.format(GETTER_PATTERN, bodyCode);
        JavaMethod method = JavaElementFactory.newMethod(modifiers, type, methodName, content, overridde, new JavaArgument[0]);
        this.addMethod(method);
        return method;
    }

    public JavaMethod addOverrideGetterMethod(String id, int modifiers, String type, boolean useOverride) {
        String capitalizedName = StringUtils.capitalize((String)id);
        String methodName = "get" + capitalizedName;
        String bodyCode = useOverride ? "super." + methodName + "()" : id;
        bodyCode = "(" + type + ")" + bodyCode;
        String content = String.format(GETTER_PATTERN, bodyCode);
        JavaMethod method = JavaElementFactory.newMethod(modifiers, type, methodName, content, true, new JavaArgument[0]);
        this.addMethod(method);
        return method;
    }

    public void addField(JavaField field, boolean javaBean) {
        this.addSimpleField(field);
        String id = field.getName();
        String capitalizedName = StringUtils.capitalize((String)id);
        int modifiers = Modifier.isProtected(field.getModifiers()) ? 1 : 4;
        this.addGetterMethod(id, modifiers, field.getType(), field.isOverride(), false);
        if (javaBean) {
            String content;
            String constantId = TypeManager.convertVariableNameToConstantName("property" + capitalizedName);
            this.addSimpleField(JavaElementFactory.newField(25, "String", constantId, false, "\"" + id + "\"", new String[0]));
            if (Boolean.class.getSimpleName().equals(field.getType())) {
                content = String.format(BOOLEAN_GETTER_PATTERN, id);
                JavaMethod method = JavaElementFactory.newMethod(1, field.getType(), "is" + capitalizedName, content, field.isOverride(), new JavaArgument[0]);
                this.addMethod(method);
            }
            content = String.format(SETTER_PATTERN, field.getType(), id, constantId);
            JavaArgument arg = JavaElementFactory.newArgument(field.getType(), id);
            JavaMethod method = JavaElementFactory.newMethod(1, "void", "set" + capitalizedName, content, field.isOverride(), arg);
            this.addMethod(method);
        }
    }

    public void addSimpleField(JavaField field) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + this.getName() + "] Add field " + field.getName()));
        }
        String fieldType = field.getType();
        try {
            String type = this.importManager.getType(fieldType);
            field.setType(type);
        }
        catch (Exception e) {
            log.error((Object)("Could not determine simple name of field [" + field.getName() + "] type " + fieldType));
        }
        if (field.hasInitializerTypes()) {
            String code = this.simplifyCode(field.getInitializer(), field.getInitializerTypes());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Use simplify text : " + code));
            }
            field.setInitializer(code);
        }
        this.fields.add(field);
    }

    public void setSuperclassIsJAXXObject(boolean superclassIsJAXXObject) {
        this.superclassIsJAXXObject = superclassIsJAXXObject;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    public void setSuperGenericType(String superGenericType) {
        this.superGenericType = superGenericType;
    }

    public void addBodyCode(String bodyCode) {
        this.rawBodyCode.append(bodyCode);
    }

    public String simplifyCode(String pattern, String ... types) {
        String[] simpleTypes = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            String simpleType;
            String type = types[i];
            simpleTypes[i] = simpleType = this.importManager.getType(type);
        }
        return String.format(pattern, simpleTypes);
    }

    public void clear() {
        this.importManager.clearImports();
        if (this.interfaces != null) {
            this.interfaces.clear();
            this.interfaces = null;
        }
        if (this.methods != null) {
            this.methods.clear();
            this.methods = null;
        }
        if (this.constructors != null) {
            this.constructors.clear();
            this.constructors = null;
        }
        if (this.fields != null) {
            this.fields.clear();
            this.fields = null;
        }
        if (this.imports != null) {
            this.imports.clear();
        }
    }

    public List<JavaConstructor> getConstructors() {
        return this.constructors;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }
}

