/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.helper.plugin;

import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="transform-project-version", defaultPhase=LifecyclePhase.INITIALIZE, aggregator=true, requiresProject=true)
public class TransformProjectVersionMojo
extends AbstractPlugin {
    public static final String SNAPSHOT_SUFFIX = "-SNAPSHOT";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="helper.revision", required=true)
    private String revision;
    @Parameter(property="helper.newVersionPattern", defaultValue="#V-rev-#R")
    private String newVersionPattern = "#V-rev-#R";
    @Parameter(property="helper.versionKey", defaultValue="newVersion", required=true)
    private String versionKey = "newVersion";
    @Parameter(property="helper.verbose", defaultValue="${maven.verbose}")
    private boolean verbose;
    @Parameter(property="helper.runOnce", defaultValue="true")
    private boolean runOnce;

    public boolean checkSkip() {
        boolean result = true;
        if (this.runOnce) {
            String key = "transform-project-version##" + this.revision;
            boolean shouldInvoke = this.needInvoke(true, false, key);
            result = shouldInvoke && super.checkSkip();
        }
        return result;
    }

    protected void init() throws Exception {
        if (!this.newVersionPattern.contains("#V") && !this.newVersionPattern.contains("#R")) {
            throw new MojoExecutionException("newVersionPattern (" + this.newVersionPattern + ") must at least contains one of those patterns: *#V* or *#R*.");
        }
        if (this.newVersionPattern.contains("#S")) {
            int lastIndex;
            int firstIndex = this.newVersionPattern.indexOf("#S");
            if (firstIndex != (lastIndex = this.newVersionPattern.lastIndexOf("#S"))) {
                throw new MojoExecutionException("newVersionPattern (" + this.newVersionPattern + ") can only contains one pattern *#S*.");
            }
            if (lastIndex != this.newVersionPattern.length() - 2) {
                throw new MojoExecutionException("newVersionPattern (" + this.newVersionPattern + ") can only contains pattern *#S* at his end.");
            }
        }
        if (this.revision.startsWith("#")) {
            this.revision = (String)this.getProject().getProperties().get(this.revision.substring(1));
        }
    }

    protected void doAction() throws Exception {
        boolean snapshotFound;
        String version = this.getProject().getVersion();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Initial version: " + version));
        }
        if (snapshotFound = version.endsWith(SNAPSHOT_SUFFIX)) {
            version = version.substring(0, version.length() - SNAPSHOT_SUFFIX.length());
        }
        String newVersion = this.newVersionPattern.replaceAll("#V", version);
        newVersion = newVersion.replaceAll("#R", this.revision);
        newVersion = newVersion.replaceAll("#S", SNAPSHOT_SUFFIX);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("New     version: " + newVersion));
        }
        Properties properties = this.project.getProperties();
        this.getLog().info((CharSequence)("export newVersion [" + newVersion + "]  in ${" + this.versionKey + "}"));
        properties.setProperty(this.versionKey, newVersion);
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

