/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.guix;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SwingEventHandler {
    Log log = LogFactory.getLog(SwingEventHandler.class);
    Map<EventSetDescriptor, Map<Method, String>> map = new HashMap<EventSetDescriptor, Map<Method, String>>();

    public boolean addEvent(Class clazz, String name, String value) throws IntrospectionException {
        Object methods;
        if (clazz == null || name == null || value == null) {
            return false;
        }
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        EventSetDescriptor[] esds = bi.getEventSetDescriptors();
        int j = 0;
        EventSetDescriptor esd = null;
        Object method = null;
        for (int i = 0; i < esds.length && method == null; ++i) {
            methods = esds[i].getListenerMethods();
            for (j = 0; j < esds[i].getListenerMethods().length && method == null; ++j) {
                if (!methods[j].getName().equals(name)) continue;
                method = methods[j];
                esd = esds[i];
            }
        }
        if (method != null) {
            while (value.startsWith("{") && value.endsWith("}")) {
                value = value.substring(1, value.length() - 1);
            }
            if (!value.endsWith(";")) {
                value = value + ";";
            }
            if (this.map.get(esd) == null) {
                methods = new HashMap();
                methods.put(method, value);
                this.map.put(esd, (Map<Method, String>)methods);
            } else if (this.map.get(esd).get(method) != null) {
                this.map.get(esd).put((Method)method, this.map.get(esd).get(method) + value);
            } else {
                this.map.get(esd).put((Method)method, value);
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Event " + name + " not found."));
        }
        return method != null;
    }

    public String generate(String object) {
        StringBuffer result = new StringBuffer();
        for (EventSetDescriptor e : this.map.keySet()) {
            result.append(object).append(".").append(e.getAddListenerMethod().getName()).append("(new ").append(e.getListenerMethods().length == 1 ? e.getListenerType().getCanonicalName() : e.getListenerType().getCanonicalName().replace("Listener", "Adapter")).append("() {\n");
            for (Method m : this.map.get(e).keySet()) {
                for (Annotation a : m.getDeclaredAnnotations()) {
                    result.append(((Object)a).toString()).append("\n");
                }
                result.append("public ").append(m.getReturnType().getCanonicalName()).append(" ").append(m.getName()).append("(");
                Class<?> clazz = m.getParameterTypes()[0];
                result.append(clazz.getCanonicalName()).append(" event)").append("{\n").append(this.map.get(e).get(m)).append("\n}\n");
            }
            result.append("});\n\n");
        }
        return result.toString();
    }
}

