/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;

public class ServiceDefinitionRepresentation
extends MappingRepresentation {
    private final HashMap<String, String> uris;
    private final HashMap<String, String> templates;
    private final String basePath;

    public ServiceDefinitionRepresentation(String basePath) {
        super("service-definition");
        this.basePath = basePath;
        this.uris = new HashMap();
        this.templates = new HashMap();
    }

    public void resourceUri(String name, String subPath) {
        this.uris.put(name, this.relative(subPath));
    }

    public void resourceTemplate(String name, String subPath) {
        this.templates.put(name, this.relative(subPath));
    }

    private String relative(String subPath) {
        if (this.basePath.endsWith("/")) {
            if (subPath.startsWith("/")) {
                return this.basePath + subPath.substring(1);
            }
        } else if (!subPath.startsWith("/")) {
            return this.basePath + "/" + subPath;
        }
        return this.basePath + subPath;
    }

    public void serialize(MappingSerializer serializer) {
        serializer.putMapping("resources", new MappingRepresentation("resources"){

            protected void serialize(MappingSerializer resourceSerializer) {
                for (Map.Entry entry : ServiceDefinitionRepresentation.this.uris.entrySet()) {
                    resourceSerializer.putUri((String)entry.getKey(), (String)entry.getValue());
                }
                for (Map.Entry entry : ServiceDefinitionRepresentation.this.templates.entrySet()) {
                    resourceSerializer.putUriTemplate((String)entry.getKey(), (String)entry.getValue());
                }
            }
        });
    }
}

