/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.rest.representations;

import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.MappingRepresentation;
import org.neo4j.server.rest.repr.MappingSerializer;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.ValueRepresentation;
import org.rrd4j.core.FetchData;

public class RrdDataRepresentation
extends ObjectRepresentation {
    private final FetchData rrdData;

    public RrdDataRepresentation(FetchData rrdData) {
        super("rrd-data");
        this.rrdData = rrdData;
    }

    @ObjectRepresentation.Mapping(value="start_time")
    public ValueRepresentation getStartTime() {
        return ValueRepresentation.number((long)this.rrdData.getFirstTimestamp());
    }

    @ObjectRepresentation.Mapping(value="end_time")
    public ValueRepresentation getEndTime() {
        return ValueRepresentation.number((long)this.rrdData.getLastTimestamp());
    }

    @ObjectRepresentation.Mapping(value="timestamps")
    public ListRepresentation getTimestamps() {
        return ListRepresentation.numbers((long[])this.rrdData.getTimestamps());
    }

    @ObjectRepresentation.Mapping(value="data")
    public MappingRepresentation getDatasources() {
        return new MappingRepresentation("datasources"){

            protected void serialize(MappingSerializer serializer) {
                String[] dsNames = RrdDataRepresentation.this.rrdData.getDsNames();
                int l = dsNames.length;
                for (int i = 0; i < l; ++i) {
                    serializer.putList(dsNames[i], ListRepresentation.numbers((double[])RrdDataRepresentation.this.rrdData.getValues(i)));
                }
            }
        };
    }
}

