/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.statistic;

import java.io.Serializable;

public class StatisticData
implements Serializable {
    private static final long serialVersionUID = 1006656694124740870L;
    private static final int MEDIAN_MAX = 3000;
    private int[] requests = new int[3000];
    private int count = 0;
    private double sum = 0.0;
    private double sumSq = 0.0;
    private double min = 0.0;
    private double max = 0.0;

    public StatisticData() {
    }

    private StatisticData(int count, double sum, double sumSq, double min, double max, int[] requests) {
        this.count = count;
        this.sum = sum;
        this.sumSq = sumSq;
        this.min = min;
        this.max = max;
        System.arraycopy(requests, 0, this.requests, 0, 3000);
    }

    public double getAvg() {
        double avg = 0.0;
        if (this.count > 1) {
            avg = this.sum / (double)this.count;
        }
        return avg;
    }

    private double getVar() {
        double var = 0.0;
        if (this.count > 2) {
            var = Math.sqrt((this.sumSq - this.sum * this.sum / (double)this.count) / (double)(this.count - 1));
        }
        return var;
    }

    public int getMedian() {
        int c = 0;
        int medianPoint = this.count / 2;
        for (int i = 0; i < 3000; ++i) {
            if ((c += this.requests[i]) < medianPoint) continue;
            return i;
        }
        return 3000;
    }

    public String toString() {
        return "StatisticData{count=" + this.count + ", sum=" + this.sum + ", min=" + this.min + ", max=" + this.max + ", avg=" + this.getAvg() + ", var=" + this.getVar() + ", median=" + this.getMedian() + '}';
    }

    public StatisticData copy() {
        return new StatisticData(this.count, this.sum, this.sumSq, this.min, this.max, this.requests);
    }

    public void addValue(double value) {
        int v;
        this.min = this.count > 0 && this.min < value ? this.min : value;
        this.max = this.count > 0 && this.max > value ? this.max : value;
        ++this.count;
        this.sum += value;
        this.sumSq += value * value;
        int n = v = value >= 3000.0 ? 2999 : (value < 0.0 ? 0 : (int)value);
        this.requests[n] = this.requests[n] + 1;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getSum() {
        return this.sum;
    }
}

