/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import org.neo4j.server.rrd.RrdSampler;
import org.neo4j.server.rrd.SystemBackedTimeSource;
import org.neo4j.server.rrd.TimeSource;

public class RrdJob
implements Runnable {
    private static final long MIN_STEP_TIME = 1L;
    private RrdSampler[] sampler;
    private long lastRun = 0L;
    private TimeSource timeSource;

    public RrdJob(RrdSampler ... sampler) {
        this(new SystemBackedTimeSource(), sampler);
    }

    public RrdJob(TimeSource timeSource, RrdSampler ... sampler) {
        this.sampler = sampler;
        this.timeSource = timeSource;
    }

    @Override
    public void run() {
        if (this.timeSource.getTime() - this.lastRun >= 1L) {
            this.lastRun = this.timeSource.getTime();
            for (RrdSampler rrdSampler : this.sampler) {
                rrdSampler.updateSample();
            }
        }
    }
}

