/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.repr;

import org.neo4j.graphdb.Path;
import org.neo4j.server.rest.repr.ListRepresentation;
import org.neo4j.server.rest.repr.NodeRepresentation;
import org.neo4j.server.rest.repr.ObjectRepresentation;
import org.neo4j.server.rest.repr.RelationshipRepresentation;
import org.neo4j.server.rest.repr.RepresentationType;
import org.neo4j.server.rest.repr.ValueRepresentation;

public class FullPathRepresentation
extends ObjectRepresentation {
    private final Path path;

    public FullPathRepresentation(Path path) {
        super(RepresentationType.FULL_PATH);
        this.path = path;
    }

    @ObjectRepresentation.Mapping(value="start")
    public NodeRepresentation startNode() {
        return new NodeRepresentation(this.path.startNode());
    }

    @ObjectRepresentation.Mapping(value="end")
    public NodeRepresentation endNode() {
        return new NodeRepresentation(this.path.endNode());
    }

    @ObjectRepresentation.Mapping(value="length")
    public ValueRepresentation length() {
        return ValueRepresentation.number((int)this.path.length());
    }

    @ObjectRepresentation.Mapping(value="nodes")
    public ListRepresentation nodes() {
        return NodeRepresentation.list(this.path.nodes());
    }

    @ObjectRepresentation.Mapping(value="relationships")
    public ListRepresentation relationships() {
        return RelationshipRepresentation.list(this.path.relationships());
    }
}

