/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.batch;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;
import org.neo4j.server.rest.batch.BatchOperationResults;
import org.neo4j.server.rest.batch.BatchOperations;
import org.neo4j.server.rest.domain.BatchOperationFailedException;
import org.neo4j.server.rest.web.InternalJettyServletRequest;
import org.neo4j.server.rest.web.InternalJettyServletResponse;
import org.neo4j.server.web.WebServer;

public class NonStreamingBatchOperations
extends BatchOperations {
    private BatchOperationResults results;

    public NonStreamingBatchOperations(WebServer webServer) {
        super(webServer);
    }

    public BatchOperationResults performBatchJobs(UriInfo uriInfo, HttpHeaders httpHeaders, InputStream body) throws IOException, ServletException {
        this.results = new BatchOperationResults();
        this.parseAndPerform(uriInfo, httpHeaders, body, this.results.getLocations());
        return this.results;
    }

    @Override
    protected void invoke(String method, String path, String body, Integer id, URI targetUri, InternalJettyServletRequest req, InternalJettyServletResponse res) throws IOException, ServletException {
        this.webServer.invokeDirectly(targetUri.getPath(), (HttpServletRequest)req, (HttpServletResponse)res);
        String resultBody = res.getOutputStream().toString();
        if (!this.is2XXStatusCode(res.getStatus())) {
            throw new BatchOperationFailedException(res.getStatus(), resultBody, null);
        }
        this.results.addOperationResult(path, id, resultBody, res.getHeader("Location"));
    }
}

