/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty.util;

import java.util.EventListener;
import javax.servlet.Servlet;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mule.api.MuleContext;

public class EmbeddedJettyServer {
    private Server httpServer;

    public EmbeddedJettyServer(int port, String contextPath, String servletPath, Servlet servlet, final MuleContext context) {
        this.httpServer = new Server(port);
        for (Connector connector : this.httpServer.getConnectors()) {
            connector.setHeaderBufferSize(16384);
        }
        Context c = new Context((HandlerContainer)this.httpServer, contextPath, 1);
        c.addServlet(new ServletHolder(servlet), servletPath);
        c.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                sce.getServletContext().setAttribute("mule.context", (Object)context);
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
    }

    public void start() throws Exception {
        this.httpServer.start();
    }

    public void stop() throws Exception {
        this.httpServer.stop();
    }

    public void destroy() {
        this.httpServer.destroy();
    }

    public boolean isStarted() {
        return this.httpServer.isStarted();
    }
}

