/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.servlet.jetty;

import java.util.ArrayList;
import org.mule.module.logging.MuleLoggerFactory;
import org.mule.util.StringMessageUtils;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.StaticLoggerBinder;

public class JettyLogger
implements org.mortbay.log.Logger {
    private Logger logger;

    public JettyLogger() {
        this.initLogger();
    }

    protected void initLogger() {
        ILoggerFactory loggerFactory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        String message = null;
        if (!(loggerFactory instanceof MuleLoggerFactory)) {
            ArrayList<String> messages = new ArrayList<String>();
            messages.add("Mule's StaticLoggerBinder should be installed but isn't.");
            messages.add("Logger factory in place is: " + loggerFactory.getClass().getName());
            message = StringMessageUtils.getBoilerPlate(messages, (char)'!', (int)70);
        }
        this.logger = loggerFactory.getLogger("org.mortbay.jetty");
        if (message != null) {
            this.logger.warn(message);
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void setDebugEnabled(boolean enabled) {
        this.warn("Ignoring call to unsupported method 'setDebugEnabled'", null, null);
    }

    public void info(String msg, Object arg0, Object arg1) {
        this.logger.info(msg, arg0, arg1);
    }

    public void debug(String msg, Throwable th) {
        this.logger.debug(msg, th);
    }

    public void debug(String msg, Object arg0, Object arg1) {
        this.logger.debug(msg, arg0, arg1);
    }

    public void warn(String msg, Object arg0, Object arg1) {
        this.logger.warn(msg, arg0, arg1);
    }

    public void warn(String msg, Throwable th) {
        this.logger.warn(msg, th);
    }

    public org.mortbay.log.Logger getLogger(String name) {
        return this;
    }
}

