/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.mapstruct.ap.internal.gem.AfterMappingGem;
import org.mapstruct.ap.internal.gem.BeforeMappingGem;
import org.mapstruct.ap.internal.util.accessor.Accessor;

public class Executables {
    private static final Method DEFAULT_METHOD;

    private Executables() {
    }

    static boolean isPublicNotStatic(ExecutableElement method) {
        return Executables.isPublic(method) && Executables.isNotStatic(method);
    }

    static boolean isPublic(ExecutableElement method) {
        return method.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    private static boolean isNotStatic(ExecutableElement method) {
        return !method.getModifiers().contains((Object)Modifier.STATIC);
    }

    public static boolean isFinal(Accessor accessor) {
        return accessor != null && accessor.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static boolean isDefaultMethod(ExecutableElement method) {
        try {
            return DEFAULT_METHOD != null && Boolean.TRUE.equals(DEFAULT_METHOD.invoke((Object)method, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean isLifecycleCallbackMethod(ExecutableElement executableElement) {
        return Executables.isBeforeMappingMethod(executableElement) || Executables.isAfterMappingMethod(executableElement);
    }

    public static boolean isAfterMappingMethod(ExecutableElement executableElement) {
        return AfterMappingGem.instanceOn(executableElement) != null;
    }

    public static boolean isBeforeMappingMethod(ExecutableElement executableElement) {
        return BeforeMappingGem.instanceOn(executableElement) != null;
    }

    static {
        Method method;
        try {
            method = ExecutableElement.class.getMethod("isDefault", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        DEFAULT_METHOD = method;
    }
}

