/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.conversion.AbstractNumberToStringConversion;
import org.mapstruct.ap.internal.conversion.ConversionUtils;
import org.mapstruct.ap.internal.conversion.CreateDecimalFormat;
import org.mapstruct.ap.internal.model.HelperMethod;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Collections;

public class BigIntegerToStringConversion
extends AbstractNumberToStringConversion {
    public BigIntegerToStringConversion() {
        super(true);
    }

    @Override
    public String getToExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".format( <SOURCE> )");
            return sb.toString();
        }
        return "<SOURCE>.toString()";
    }

    @Override
    public String getFromExpression(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            StringBuilder sb = new StringBuilder();
            sb.append("( (").append(ConversionUtils.bigDecimal(conversionContext)).append(") ");
            this.appendDecimalFormatter(sb, conversionContext);
            sb.append(".parse( <SOURCE> )");
            sb.append(" ).toBigInteger()");
            return sb.toString();
        }
        return "new " + ConversionUtils.bigInteger(conversionContext) + "( <SOURCE> )";
    }

    @Override
    protected Set<Type> getFromConversionImportTypes(ConversionContext conversionContext) {
        if (this.requiresDecimalFormat(conversionContext)) {
            return Collections.asSet(conversionContext.getTypeFactory().getType(BigDecimal.class));
        }
        return Collections.asSet(conversionContext.getTypeFactory().getType(BigInteger.class));
    }

    @Override
    public List<HelperMethod> getRequiredHelperMethods(ConversionContext conversionContext) {
        ArrayList<HelperMethod> helpers = new ArrayList<HelperMethod>();
        if (conversionContext.getNumberFormat() != null) {
            helpers.add(new CreateDecimalFormat(conversionContext.getTypeFactory()));
        }
        return helpers;
    }

    private void appendDecimalFormatter(StringBuilder sb, ConversionContext conversionContext) {
        sb.append("createDecimalFormat( ");
        if (conversionContext.getNumberFormat() != null) {
            sb.append("\"");
            sb.append(conversionContext.getNumberFormat());
            sb.append("\"");
        }
        sb.append(" )");
    }
}

