/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.InvalidReferenceException;
import org.mapstruct.ap.shaded.freemarker.core.LocalContext;
import org.mapstruct.ap.shaded.freemarker.core.MessageUtil;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.core.TextBlock;
import org.mapstruct.ap.shaded.freemarker.core._DelayedJQuote;
import org.mapstruct.ap.shaded.freemarker.core._ErrorDescriptionBuilder;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelIterator;

public final class Macro
extends TemplateElement
implements TemplateModel {
    final int TYPE_MACRO = 0;
    final int TYPE_FUNCTION = 1;
    private final String name;
    private final String[] paramNames;
    private Map paramDefaults;
    private String catchAllParamName;
    boolean isFunction;
    static final Macro DO_NOTHING_MACRO = new Macro(".pass", Collections.EMPTY_LIST, Collections.EMPTY_MAP, TextBlock.EMPTY_BLOCK);

    Macro(String name, List argumentNames, Map args, TemplateElement nestedBlock) {
        this.name = name;
        this.paramNames = argumentNames.toArray(new String[argumentNames.size()]);
        this.paramDefaults = args;
        this.nestedBlock = nestedBlock;
    }

    public String getCatchAll() {
        return this.catchAllParamName;
    }

    public void setCatchAll(String value) {
        this.catchAllParamName = value;
    }

    public String[] getArgumentNames() {
        return (String[])this.paramNames.clone();
    }

    String[] getArgumentNamesInternal() {
        return this.paramNames;
    }

    boolean hasArgNamed(String name) {
        return this.paramDefaults.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    void accept(Environment env) {
        env.visitMacroDef(this);
    }

    protected String dump(boolean canonical) {
        StringBuffer sb = new StringBuffer();
        if (canonical) {
            sb.append('<');
        }
        sb.append(this.getNodeTypeSymbol());
        sb.append(' ');
        sb.append(this.name);
        sb.append(this.isFunction ? (char)'(' : ' ');
        int argCnt = this.paramNames.length;
        for (int i = 0; i < argCnt; ++i) {
            if (i != 0) {
                if (this.isFunction) {
                    sb.append(", ");
                } else {
                    sb.append(' ');
                }
            }
            String argName = this.paramNames[i];
            sb.append(argName);
            if (this.paramDefaults == null || this.paramDefaults.get(argName) == null) continue;
            sb.append('=');
            Expression defaultExpr = (Expression)this.paramDefaults.get(argName);
            if (this.isFunction) {
                sb.append(defaultExpr.getCanonicalForm());
                continue;
            }
            MessageUtil.appendExpressionAsUntearable(sb, defaultExpr);
        }
        if (this.catchAllParamName != null) {
            if (argCnt != 0) {
                sb.append(", ");
            }
            sb.append(this.catchAllParamName);
            sb.append("...");
        }
        if (this.isFunction) {
            sb.append(')');
        }
        if (canonical) {
            sb.append('>');
            if (this.nestedBlock != null) {
                sb.append(this.nestedBlock.getCanonicalForm());
            }
            sb.append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return sb.toString();
    }

    String getNodeTypeSymbol() {
        return this.isFunction ? "#function" : "#macro";
    }

    boolean isShownInStackTrace() {
        return false;
    }

    public boolean isFunction() {
        return this.isFunction;
    }

    int getParameterCount() {
        return 1 + this.paramNames.length * 2 + 1 + 1;
    }

    Object getParameterValue(int idx) {
        if (idx == 0) {
            return this.name;
        }
        int argDescsEnd = this.paramNames.length * 2 + 1;
        if (idx < argDescsEnd) {
            String paramName = this.paramNames[(idx - 1) / 2];
            if (idx % 2 != 0) {
                return paramName;
            }
            return this.paramDefaults.get(paramName);
        }
        if (idx == argDescsEnd) {
            return this.catchAllParamName;
        }
        if (idx == argDescsEnd + 1) {
            return new Integer(this.isFunction ? 1 : 0);
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        if (idx == 0) {
            return ParameterRole.ASSIGNMENT_TARGET;
        }
        int argDescsEnd = this.paramNames.length * 2 + 1;
        if (idx < argDescsEnd) {
            if (idx % 2 != 0) {
                return ParameterRole.PARAMETER_NAME;
            }
            return ParameterRole.PARAMETER_DEFAULT;
        }
        if (idx == argDescsEnd) {
            return ParameterRole.CATCH_ALL_PARAMETER_NAME;
        }
        if (idx == argDescsEnd + 1) {
            return ParameterRole.AST_NODE_SUBTYPE;
        }
        throw new IndexOutOfBoundsException();
    }

    class Context
    implements LocalContext {
        Environment.Namespace localVars;
        TemplateElement body;
        Environment.Namespace bodyNamespace;
        List bodyParameterNames;
        Context prevMacroContext;
        ArrayList prevLocalContextStack;

        Context(Environment env, TemplateElement body, List bodyParameterNames) {
            this.localVars = env.new Environment.Namespace();
            this.prevMacroContext = env.getCurrentMacroContext();
            this.bodyNamespace = env.getCurrentNamespace();
            this.prevLocalContextStack = env.getLocalContextStack();
            this.body = body;
            this.bodyParameterNames = bodyParameterNames;
        }

        Macro getMacro() {
            return Macro.this;
        }

        void runMacro(Environment env) throws TemplateException, IOException {
            this.sanityCheck(env);
            if (Macro.this.nestedBlock != null) {
                env.visit(Macro.this.nestedBlock);
            }
        }

        void sanityCheck(Environment env) throws TemplateException {
            InvalidReferenceException firstReferenceException;
            Expression firstUnresolvedExpression;
            boolean hasUnresolvedArg;
            boolean resolvedAnArg;
            do {
                firstUnresolvedExpression = null;
                firstReferenceException = null;
                hasUnresolvedArg = false;
                resolvedAnArg = false;
                for (int i = 0; i < Macro.this.paramNames.length; ++i) {
                    Object[] objectArray;
                    String argName = Macro.this.paramNames[i];
                    if (this.localVars.get(argName) != null) continue;
                    Expression valueExp = (Expression)Macro.this.paramDefaults.get(argName);
                    if (valueExp != null) {
                        try {
                            TemplateModel tm = valueExp.eval(env);
                            if (tm == null) {
                                if (hasUnresolvedArg) continue;
                                firstUnresolvedExpression = valueExp;
                                hasUnresolvedArg = true;
                                continue;
                            }
                            this.localVars.put(argName, tm);
                            resolvedAnArg = true;
                        }
                        catch (InvalidReferenceException e) {
                            if (hasUnresolvedArg) continue;
                            hasUnresolvedArg = true;
                            firstReferenceException = e;
                        }
                        continue;
                    }
                    if (env.isClassicCompatible()) continue;
                    boolean argWasSpecified = this.localVars.containsKey(argName);
                    _ErrorDescriptionBuilder _ErrorDescriptionBuilder2 = new _ErrorDescriptionBuilder(new Object[]{"When calling macro ", new _DelayedJQuote(Macro.this.name), ", required parameter ", new _DelayedJQuote(argName), " (parameter #", new Integer(i + 1), ") was ", argWasSpecified ? "specified, but had null/missing value." : "not specified."});
                    if (argWasSpecified) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = "If the parameter value expression on the caller side is known to be legally null/missing, you may want to specify a default value for it with the \"!\" operator, like paramValue!defaultValue.";
                    } else {
                        Object[] objectArray3 = new Object[3];
                        objectArray3[0] = "If the omission was deliberate, you may consider making the parameter optional in the macro by specifying a default value for it, like ";
                        objectArray3[1] = "<#macro macroName paramName=defaultExpr>";
                        objectArray = objectArray3;
                        objectArray3[2] = ")";
                    }
                    throw new _MiscTemplateException(env, _ErrorDescriptionBuilder2.tip(objectArray));
                }
            } while (resolvedAnArg && hasUnresolvedArg);
            if (hasUnresolvedArg) {
                if (firstReferenceException != null) {
                    throw firstReferenceException;
                }
                if (!env.isClassicCompatible()) {
                    throw InvalidReferenceException.getInstance(firstUnresolvedExpression, env);
                }
            }
        }

        public TemplateModel getLocalVariable(String name) throws TemplateModelException {
            return this.localVars.get(name);
        }

        Environment.Namespace getLocals() {
            return this.localVars;
        }

        void setLocalVar(String name, TemplateModel var) {
            this.localVars.put(name, var);
        }

        public Collection getLocalVariableNames() throws TemplateModelException {
            HashSet<String> result = new HashSet<String>();
            TemplateModelIterator it = this.localVars.keys().iterator();
            while (it.hasNext()) {
                result.add(it.next().toString());
            }
            return result;
        }
    }
}

