/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.beanmapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;

public class TargetReference {
    private final List<String> pathProperties;
    private final Parameter parameter;
    private final List<String> propertyEntries;

    public TargetReference(Parameter parameter, List<String> propertyEntries) {
        this(parameter, propertyEntries, java.util.Collections.emptyList());
    }

    public TargetReference(Parameter parameter, List<String> propertyEntries, List<String> pathProperties) {
        this.pathProperties = pathProperties;
        this.parameter = parameter;
        this.propertyEntries = propertyEntries;
    }

    public List<String> getPathProperties() {
        return this.pathProperties;
    }

    public List<String> getPropertyEntries() {
        return this.propertyEntries;
    }

    public List<String> getElementNames() {
        ArrayList<String> elementNames = new ArrayList<String>();
        if (this.parameter != null) {
            elementNames.add(this.parameter.getName());
        }
        elementNames.addAll(this.propertyEntries);
        return elementNames;
    }

    public String getShallowestPropertyName() {
        if (this.propertyEntries.isEmpty()) {
            return null;
        }
        return Collections.first(this.propertyEntries);
    }

    public boolean isNested() {
        return this.propertyEntries.size() > 1;
    }

    public String toString() {
        String result = "";
        if (this.propertyEntries.isEmpty()) {
            if (this.parameter != null) {
                result = String.format("parameter \"%s %s\"", this.parameter.getType(), this.parameter.getName());
            }
        } else if (this.propertyEntries.size() == 1) {
            String propertyEntry = this.propertyEntries.get(0);
            result = String.format("property \"%s\"", propertyEntry);
        } else {
            result = String.format("property \"%s\"", Strings.join(this.getElementNames(), "."));
        }
        return result;
    }

    public TargetReference pop() {
        if (this.getPropertyEntries().size() > 1) {
            ArrayList<String> newPathProperties = new ArrayList<String>(this.pathProperties);
            newPathProperties.add(this.getPropertyEntries().get(0));
            return new TargetReference(null, this.getPropertyEntries().subList(1, this.getPropertyEntries().size()), newPathProperties);
        }
        return null;
    }

    public static class Builder {
        private Method method;
        private FormattingMessager messager;
        private TypeFactory typeFactory;
        private Set<String> targetProperties;
        private Type targetType;
        private String targetName = null;
        private MappingOptions mapping;
        private AnnotationMirror annotationMirror = null;
        private AnnotationValue targetAnnotationValue = null;
        private AnnotationValue sourceAnnotationValue = null;

        public Builder messager(FormattingMessager messager) {
            this.messager = messager;
            return this;
        }

        public Builder mapping(MappingOptions mapping) {
            this.mapping = mapping;
            this.targetName = mapping.getTargetName();
            this.annotationMirror = mapping.getMirror();
            this.targetAnnotationValue = mapping.getTargetAnnotationValue();
            this.sourceAnnotationValue = mapping.getSourceAnnotationValue();
            return this;
        }

        public Builder typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder method(Method method) {
            this.method = method;
            return this;
        }

        public Builder targetProperties(Set<String> targetProperties) {
            this.targetProperties = targetProperties;
            return this;
        }

        public Builder targetType(Type targetType) {
            this.targetType = targetType;
            return this;
        }

        public TargetReference build() {
            String firstTargetProperty;
            Objects.requireNonNull(this.method);
            Objects.requireNonNull(this.typeFactory);
            Objects.requireNonNull(this.messager);
            Objects.requireNonNull(this.targetType);
            if (this.targetName == null) {
                return null;
            }
            String targetNameTrimmed = this.targetName.trim();
            if (!this.targetName.equals(targetNameTrimmed)) {
                this.messager.printMessage((Element)this.method.getExecutable(), this.annotationMirror, this.targetAnnotationValue, Message.PROPERTYMAPPING_WHITESPACE_TRIMMED, this.targetName, targetNameTrimmed);
            }
            String[] segments = targetNameTrimmed.split("\\.");
            Parameter parameter = this.method.getMappingTargetParameter();
            String[] targetPropertyNames = segments;
            if (segments.length > 1 && !this.targetProperties.contains(firstTargetProperty = targetPropertyNames[0]) && this.matchesSourceOrTargetParameter(firstTargetProperty, parameter)) {
                targetPropertyNames = Arrays.copyOfRange(segments, 1, segments.length);
            }
            ArrayList<String> entries = new ArrayList<String>(Arrays.asList(targetPropertyNames));
            return new TargetReference(parameter, entries);
        }

        private boolean matchesSourceOrTargetParameter(String segment, Parameter targetParameter) {
            boolean matchesTargetParameter = targetParameter != null && targetParameter.getName().equals(segment);
            return matchesTargetParameter || this.matchesSourceOnInverseSourceParameter(segment);
        }

        private boolean matchesSourceOnInverseSourceParameter(String segment) {
            boolean result = false;
            MappingOptions.InheritContext inheritContext = this.mapping.getInheritContext();
            if (inheritContext != null && inheritContext.isReversed()) {
                Method templateMethod = inheritContext.getTemplateMethod();
                Parameter inverseSourceParameter = Collections.first(templateMethod.getSourceParameters());
                result = inverseSourceParameter.getName().equals(segment);
            }
            return result;
        }
    }
}

