/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.util.ArrayList;
import org.mapstruct.ap.shaded.freemarker.core.BooleanLiteral;
import org.mapstruct.ap.shaded.freemarker.core.BuiltIn;
import org.mapstruct.ap.shaded.freemarker.core.Dot;
import org.mapstruct.ap.shaded.freemarker.core.DynamicKeyName;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.HashLiteral;
import org.mapstruct.ap.shaded.freemarker.core.Identifier;
import org.mapstruct.ap.shaded.freemarker.core.ListLiteral;
import org.mapstruct.ap.shaded.freemarker.core.Macro;
import org.mapstruct.ap.shaded.freemarker.core.MethodCall;
import org.mapstruct.ap.shaded.freemarker.core.NumberLiteral;
import org.mapstruct.ap.shaded.freemarker.core.StringLiteral;
import org.mapstruct.ap.shaded.freemarker.core.UnformattableDateException;
import org.mapstruct.ap.shaded.freemarker.core.UnknownDateTypeFormattingUnsupportedException;
import org.mapstruct.ap.shaded.freemarker.core._DelayedAOrAn;
import org.mapstruct.ap.shaded.freemarker.core._DelayedFTLTypeDescription;
import org.mapstruct.ap.shaded.freemarker.core._ErrorDescriptionBuilder;
import org.mapstruct.ap.shaded.freemarker.core._MiscTemplateException;
import org.mapstruct.ap.shaded.freemarker.core._TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.Template;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModel;
import org.mapstruct.ap.shaded.freemarker.template.TemplateModelException;
import org.mapstruct.ap.shaded.freemarker.template.utility.StringUtil;

class MessageUtil {
    static final String UNKNOWN_DATE_TO_STRING_ERROR_MESSAGE = "Can't convert the date-like value to string because it isn't known if it's a date (no time part), time or date-time value.";
    static final String UNKNOWN_DATE_TYPE_ERROR_TIP = "Use ?date, ?time, or ?datetime to tell FreeMarker the exact type.";
    static final String[] UNKNOWN_DATE_TO_STRING_TIPS = new String[]{"Use ?date, ?time, or ?datetime to tell FreeMarker the exact type.", "If you need a particular format only once, use ?string(pattern), like ?string('dd.MM.yyyy HH:mm:ss'), to specify which fields to display. "};
    static final String EMBEDDED_MESSAGE_BEGIN = "---begin-message---\n";
    static final String EMBEDDED_MESSAGE_END = "\n---end-message---";

    private MessageUtil() {
    }

    static String formatLocationForSimpleParsingError(Template template, int line, int column) {
        return MessageUtil.formatLocation("in", template, line, column);
    }

    static String formatLocationForSimpleParsingError(String templateName, int line, int column) {
        return MessageUtil.formatLocation("in", templateName, line, column);
    }

    static String formatLocationForDependentParsingError(Template template, int line, int column) {
        return MessageUtil.formatLocation("on", template, line, column);
    }

    static String formatLocationForDependentParsingError(String templateName, int line, int column) {
        return MessageUtil.formatLocation("on", templateName, line, column);
    }

    static String formatLocationForEvaluationError(Template template, int line, int column) {
        return MessageUtil.formatLocation("at", template, line, column);
    }

    static String formatLocationForEvaluationError(Macro macro, int line, int column) {
        Template t = macro.getTemplate();
        return MessageUtil.formatLocation("at", t != null ? t.getName() : null, macro.getName(), macro.isFunction(), line, column);
    }

    static String formatLocationForEvaluationError(String templateName, int line, int column) {
        return MessageUtil.formatLocation("at", templateName, line, column);
    }

    private static String formatLocation(String preposition, Template template, int line, int column) {
        return MessageUtil.formatLocation(preposition, template != null ? template.getName() : null, line, column);
    }

    private static String formatLocation(String preposition, String templateName, int line, int column) {
        return MessageUtil.formatLocation(preposition, templateName, null, false, line, column);
    }

    private static String formatLocation(String preposition, String templateName, String macroOrFuncName, boolean isFunction, int line, int column) {
        String templateDesc;
        if (line < 0) {
            templateDesc = "?eval-ed string";
            line += 1000000001;
            macroOrFuncName = null;
        } else {
            templateDesc = templateName != null ? "template " + StringUtil.jQuoteNoXSS(templateName) : "nameless template";
        }
        return "in " + templateDesc + (macroOrFuncName != null ? " in " + (isFunction ? "function " : "macro ") + StringUtil.jQuote(macroOrFuncName) : "") + " " + preposition + " line " + line + ", column " + column;
    }

    static String shorten(String s, int maxLength) {
        if (maxLength < 5) {
            maxLength = 5;
        }
        boolean isTruncated = false;
        int brIdx = s.indexOf(10);
        if (brIdx != -1) {
            s = s.substring(0, brIdx);
            isTruncated = true;
        }
        if ((brIdx = s.indexOf(13)) != -1) {
            s = s.substring(0, brIdx);
            isTruncated = true;
        }
        if (s.length() > maxLength) {
            s = s.substring(0, maxLength - 3);
            isTruncated = true;
        }
        if (!isTruncated) {
            return s;
        }
        if (s.endsWith(".")) {
            if (s.endsWith("..")) {
                if (s.endsWith("...")) {
                    return s;
                }
                return s + ".";
            }
            return s + "..";
        }
        return s + "...";
    }

    static StringBuffer appendExpressionAsUntearable(StringBuffer sb, Expression argExp) {
        boolean needParen;
        boolean bl = needParen = !(argExp instanceof NumberLiteral) && !(argExp instanceof StringLiteral) && !(argExp instanceof BooleanLiteral) && !(argExp instanceof ListLiteral) && !(argExp instanceof HashLiteral) && !(argExp instanceof Identifier) && !(argExp instanceof Dot) && !(argExp instanceof DynamicKeyName) && !(argExp instanceof MethodCall) && !(argExp instanceof BuiltIn);
        if (needParen) {
            sb.append('(');
        }
        sb.append(argExp.getCanonicalForm());
        if (needParen) {
            sb.append(')');
        }
        return sb;
    }

    static TemplateModelException newArgCntError(String methodName, int argCnt, int expectedCnt) {
        return MessageUtil.newArgCntError(methodName, argCnt, expectedCnt, expectedCnt);
    }

    static TemplateModelException newArgCntError(String methodName, int argCnt, int minCnt, int maxCnt) {
        ArrayList<Object> desc = new ArrayList<Object>(20);
        desc.add(methodName);
        desc.add("(");
        if (maxCnt != 0) {
            desc.add("...");
        }
        desc.add(") expects ");
        if (minCnt == maxCnt) {
            if (maxCnt == 0) {
                desc.add("no");
            } else {
                desc.add(new Integer(maxCnt));
            }
        } else if (maxCnt - minCnt == 1) {
            desc.add(new Integer(minCnt));
            desc.add(" or ");
            desc.add(new Integer(maxCnt));
        } else {
            desc.add(new Integer(minCnt));
            if (maxCnt != Integer.MAX_VALUE) {
                desc.add(" to ");
                desc.add(new Integer(maxCnt));
            } else {
                desc.add(" or more (unlimited)");
            }
        }
        desc.add(" argument");
        if (maxCnt > 1) {
            desc.add("s");
        }
        desc.add(" but has received ");
        if (argCnt == 0) {
            desc.add("none");
        } else {
            desc.add(new Integer(argCnt));
        }
        desc.add(".");
        return new _TemplateModelException(desc.toArray());
    }

    static TemplateModelException newMethodArgMustBeStringException(String methodName, int argIdx, TemplateModel arg) {
        return MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "string", arg);
    }

    static TemplateModelException newMethodArgMustBeNumberException(String methodName, int argIdx, TemplateModel arg) {
        return MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "number", arg);
    }

    static TemplateModelException newMethodArgMustBeBooleanException(String methodName, int argIdx, TemplateModel arg) {
        return MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "boolean", arg);
    }

    static TemplateModelException newMethodArgMustBeExtendedHashException(String methodName, int argIdx, TemplateModel arg) {
        return MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "extended hash", arg);
    }

    static TemplateModelException newMethodArgMustBeSequenceException(String methodName, int argIdx, TemplateModel arg) {
        return MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "sequence", arg);
    }

    static TemplateModelException newMethodArgMustBeSequenceOrCollectionException(String methodName, int argIdx, TemplateModel arg) {
        return MessageUtil.newMethodArgUnexpectedTypeException(methodName, argIdx, "sequence or collection", arg);
    }

    static TemplateModelException newMethodArgUnexpectedTypeException(String methodName, int argIdx, String expectedType, TemplateModel arg) {
        return new _TemplateModelException(new Object[]{methodName, "(...) expects ", new _DelayedAOrAn(expectedType), " as argument #", new Integer(argIdx + 1), ", but received ", new _DelayedAOrAn(new _DelayedFTLTypeDescription(arg)), "."});
    }

    static TemplateModelException newMethodArgInvalidValueException(String methodName, int argIdx, Object[] details) {
        return new _TemplateModelException(new Object[]{methodName, "(...) argument #", new Integer(argIdx + 1), " had invalid value: ", details});
    }

    static TemplateModelException newMethodArgsInvalidValueException(String methodName, Object[] details) {
        return new _TemplateModelException(new Object[]{methodName, "(...) arguments have invalid value: ", details});
    }

    static TemplateException newInstantiatingClassNotAllowedException(String className, Environment env) {
        return new _MiscTemplateException(env, new Object[]{"Instantiating ", className, " is not allowed in the template for security reasons."});
    }

    static _TemplateModelException newCantFormatUnknownTypeDateException(Expression dateSourceExpr, UnknownDateTypeFormattingUnsupportedException cause) {
        return new _TemplateModelException((Throwable)cause, null, new _ErrorDescriptionBuilder(UNKNOWN_DATE_TO_STRING_ERROR_MESSAGE).blame(dateSourceExpr).tips(UNKNOWN_DATE_TO_STRING_TIPS));
    }

    static TemplateModelException newCantFormatDateException(Expression dateSourceExpr, UnformattableDateException cause) {
        return new _TemplateModelException((Throwable)cause, null, new _ErrorDescriptionBuilder(cause.getMessage()).blame(dateSourceExpr));
    }

    static String getAOrAn(String s) {
        char sc;
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "";
        }
        char fc = Character.toLowerCase(s.charAt(0));
        if (fc == 'a' || fc == 'e' || fc == 'i') {
            return "an";
        }
        if (fc == 'h') {
            String ls = s.toLowerCase();
            if (ls.startsWith("has") || ls.startsWith("hi")) {
                return "a";
            }
            if (ls.startsWith("ht")) {
                return "an";
            }
            return "a(n)";
        }
        if (fc == 'u' || fc == 'o') {
            return "a(n)";
        }
        char c = sc = s.length() > 1 ? s.charAt(1) : (char)'\u0000';
        if (fc == 'x' && sc != 'a' && sc != 'e' && sc != 'i' && sc != 'a' && sc != 'o' && sc != 'u') {
            return "an";
        }
        return "a";
    }
}

