/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.Filters;
import org.mapstruct.ap.internal.util.Nouns;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.ExecutableElementAccessor;

public class Type
extends ModelElement
implements Comparable<Type> {
    private final Types typeUtils;
    private final Elements elementUtils;
    private final TypeFactory typeFactory;
    private final TypeMirror typeMirror;
    private final TypeElement typeElement;
    private final List<Type> typeParameters;
    private final Type implementationType;
    private final Type componentType;
    private final String packageName;
    private final String name;
    private final String qualifiedName;
    private final boolean isInterface;
    private final boolean isEnumType;
    private final boolean isIterableType;
    private final boolean isCollectionType;
    private final boolean isMapType;
    private final boolean isImported;
    private final boolean isVoid;
    private final boolean isStream;
    private final List<String> enumConstants;
    private Map<String, Accessor> readAccessors = null;
    private Map<String, ExecutableElementAccessor> presenceCheckers = null;
    private List<Accessor> allAccessors = null;
    private List<Accessor> setters = null;
    private List<Accessor> adders = null;
    private List<Accessor> alternativeTargetAccessors = null;
    private Type boundingBase = null;
    private Boolean hasEmptyAccessibleContructor;

    public Type(Types typeUtils, Elements elementUtils, TypeFactory typeFactory, TypeMirror typeMirror, TypeElement typeElement, List<Type> typeParameters, Type implementationType, Type componentType, String packageName, String name, String qualifiedName, boolean isInterface, boolean isEnumType, boolean isIterableType, boolean isCollectionType, boolean isMapType, boolean isStreamType, boolean isImported) {
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.typeFactory = typeFactory;
        this.typeMirror = typeMirror;
        this.typeElement = typeElement;
        this.typeParameters = typeParameters;
        this.componentType = componentType;
        this.implementationType = implementationType;
        this.packageName = packageName;
        this.name = name;
        this.qualifiedName = qualifiedName;
        this.isInterface = isInterface;
        this.isEnumType = isEnumType;
        this.isIterableType = isIterableType;
        this.isCollectionType = isCollectionType;
        this.isMapType = isMapType;
        this.isStream = isStreamType;
        this.isImported = isImported;
        boolean bl = this.isVoid = typeMirror.getKind() == TypeKind.VOID;
        if (isEnumType) {
            this.enumConstants = new ArrayList<String>();
            for (Element element : typeElement.getEnclosedElements()) {
                if (element.getKind() != ElementKind.ENUM_CONSTANT || !element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                this.enumConstants.add(element.getSimpleName().toString());
            }
        } else {
            this.enumConstants = Collections.emptyList();
        }
    }

    public TypeMirror getTypeMirror() {
        return this.typeMirror;
    }

    public TypeElement getTypeElement() {
        return this.typeElement;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public Type getComponentType() {
        return this.componentType;
    }

    public boolean isPrimitive() {
        return this.typeMirror.getKind().isPrimitive();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isEnumType() {
        return this.isEnumType;
    }

    public boolean isVoid() {
        return this.isVoid;
    }

    public boolean isAbstract() {
        return this.typeElement != null && this.typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public List<String> getEnumConstants() {
        return this.enumConstants;
    }

    public Type getImplementationType() {
        return this.implementationType;
    }

    public boolean isIterableType() {
        return this.isIterableType || this.isArrayType();
    }

    public boolean isIterableOrStreamType() {
        return this.isIterableType() || this.isStreamType();
    }

    public boolean isCollectionType() {
        return this.isCollectionType;
    }

    public boolean isMapType() {
        return this.isMapType;
    }

    public boolean isCollectionOrMapType() {
        return this.isCollectionType || this.isMapType;
    }

    public boolean isArrayType() {
        return this.componentType != null;
    }

    public boolean isTypeVar() {
        return this.typeMirror.getKind() == TypeKind.TYPEVAR;
    }

    public boolean isStreamType() {
        return this.isStream;
    }

    public boolean isWildCardSuperBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildcardType = (WildcardType)this.typeMirror;
            result = wildcardType.getSuperBound() != null;
        }
        return result;
    }

    public boolean isWildCardExtendsBound() {
        boolean result = false;
        if (this.typeMirror.getKind() == TypeKind.WILDCARD) {
            WildcardType wildcardType = (WildcardType)this.typeMirror;
            result = wildcardType.getExtendsBound() != null;
        }
        return result;
    }

    public String getFullyQualifiedName() {
        return this.qualifiedName;
    }

    public String getImportName() {
        return this.isArrayType() ? this.qualifiedName.substring(0, this.qualifiedName.length() - 2) : this.qualifiedName;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> result = new HashSet<Type>();
        if (this.getTypeMirror().getKind() == TypeKind.DECLARED) {
            result.add(this);
        }
        if (this.componentType != null) {
            result.addAll(this.componentType.getImportTypes());
        }
        for (Type parameter : this.typeParameters) {
            result.addAll(parameter.getImportTypes());
        }
        if (this.boundingBase != null) {
            result.addAll(this.boundingBase.getImportTypes());
        }
        return result;
    }

    public boolean isImported() {
        return this.isImported;
    }

    public boolean isAnnotatedWith(String annotationTypeName) {
        List<? extends AnnotationMirror> annotationMirrors = this.typeElement.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Name mirrorAnnotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
            if (!mirrorAnnotationName.contentEquals(annotationTypeName)) continue;
            return true;
        }
        return false;
    }

    public Type erasure() {
        return new Type(this.typeUtils, this.elementUtils, this.typeFactory, this.typeUtils.erasure(this.typeMirror), this.typeElement, this.typeParameters, this.implementationType, this.componentType, this.packageName, this.name, this.qualifiedName, this.isInterface, this.isEnumType, this.isIterableType, this.isCollectionType, this.isMapType, this.isStream, this.isImported);
    }

    public boolean isAssignableTo(Type other) {
        if (this.equals(other)) {
            return true;
        }
        return this.typeUtils.isAssignable(this.typeMirror, other.typeMirror);
    }

    public Map<String, Accessor> getPropertyReadAccessors() {
        if (this.readAccessors == null) {
            List<Accessor> getterList = Filters.getterMethodsIn(this.getAllAccessors());
            LinkedHashMap<String, Accessor> modifiableGetters = new LinkedHashMap<String, Accessor>();
            for (Accessor getter : getterList) {
                String propertyName = Executables.getPropertyName(getter);
                if (modifiableGetters.containsKey(propertyName)) {
                    if (getter.getSimpleName().toString().startsWith("is")) continue;
                    modifiableGetters.put(Executables.getPropertyName(getter), getter);
                    continue;
                }
                modifiableGetters.put(Executables.getPropertyName(getter), getter);
            }
            List<Accessor> fieldsList = Filters.fieldsIn(this.getAllAccessors());
            for (Accessor field : fieldsList) {
                String propertyName = Executables.getPropertyName(field);
                if (modifiableGetters.containsKey(propertyName)) continue;
                modifiableGetters.put(propertyName, field);
            }
            this.readAccessors = Collections.unmodifiableMap(modifiableGetters);
        }
        return this.readAccessors;
    }

    public Map<String, ExecutableElementAccessor> getPropertyPresenceCheckers() {
        if (this.presenceCheckers == null) {
            List<ExecutableElementAccessor> checkerList = Filters.presenceCheckMethodsIn(this.getAllAccessors());
            LinkedHashMap<String, ExecutableElementAccessor> modifiableCheckers = new LinkedHashMap<String, ExecutableElementAccessor>();
            for (ExecutableElementAccessor checker : checkerList) {
                modifiableCheckers.put(Executables.getPropertyName(checker), checker);
            }
            this.presenceCheckers = Collections.unmodifiableMap(modifiableCheckers);
        }
        return this.presenceCheckers;
    }

    public Map<String, Accessor> getPropertyWriteAccessors(CollectionMappingStrategyPrism cmStrategy) {
        ArrayList<Accessor> candidates = new ArrayList<Accessor>(this.getSetters());
        candidates.addAll(this.getAlternativeTargetAccessors());
        LinkedHashMap<String, Accessor> result = new LinkedHashMap<String, Accessor>();
        for (Accessor candidate : candidates) {
            Accessor previousCandidate;
            String targetPropertyName = Executables.getPropertyName(candidate);
            Accessor readAccessor = this.getPropertyReadAccessors().get(targetPropertyName);
            Type preferredType = this.determinePreferredType(readAccessor);
            Type targetType = this.determineTargetType(candidate);
            if (cmStrategy == CollectionMappingStrategyPrism.SETTER_PREFERRED || cmStrategy == CollectionMappingStrategyPrism.ADDER_PREFERRED || cmStrategy == CollectionMappingStrategyPrism.TARGET_IMMUTABLE) {
                Accessor adderMethod = null;
                if (Executables.isSetterMethod(candidate) && cmStrategy == CollectionMappingStrategyPrism.ADDER_PREFERRED) {
                    adderMethod = this.getAdderForType(targetType, targetPropertyName);
                } else if (Executables.isGetterMethod(candidate)) {
                    adderMethod = this.getAdderForType(targetType, targetPropertyName);
                }
                if (adderMethod != null) {
                    candidate = adderMethod;
                }
            } else if (Executables.isFieldAccessor(candidate) && (Executables.isFinal(candidate) || result.containsKey(targetPropertyName))) continue;
            if ((previousCandidate = (Accessor)result.get(targetPropertyName)) != null && preferredType != null && (targetType == null || !this.typeUtils.isAssignable(preferredType.getTypeMirror(), targetType.getTypeMirror()))) continue;
            result.put(targetPropertyName, candidate);
        }
        return result;
    }

    private Type determinePreferredType(Accessor readAccessor) {
        if (readAccessor != null) {
            return this.typeFactory.getReturnType((DeclaredType)this.typeMirror, readAccessor);
        }
        return null;
    }

    private Type determineTargetType(Accessor candidate) {
        Parameter parameter = this.typeFactory.getSingleParameter((DeclaredType)this.typeMirror, candidate);
        if (parameter != null) {
            return parameter.getType();
        }
        if (Executables.isGetterMethod(candidate) || Executables.isFieldAccessor(candidate)) {
            return this.typeFactory.getReturnType((DeclaredType)this.typeMirror, candidate);
        }
        return null;
    }

    private List<Accessor> getAllAccessors() {
        if (this.allAccessors == null) {
            this.allAccessors = Executables.getAllEnclosedAccessors(this.elementUtils, this.typeElement);
        }
        return this.allAccessors;
    }

    private Accessor getAdderForType(Type collectionProperty, String pluralPropertyName) {
        ArrayList<Accessor> candidates = new ArrayList<Accessor>();
        if (collectionProperty.isCollectionType && !collectionProperty.getTypeParameters().isEmpty()) {
            TypeMirror typeArg = collectionProperty.getTypeParameters().get(0).getTypeMirror();
            List<Accessor> adderList = this.getAdders();
            for (Accessor adder : adderList) {
                VariableElement arg;
                ExecutableElement executable = adder.getExecutable();
                if (executable == null || !(arg = executable.getParameters().get(0)).asType().equals(typeArg)) continue;
                candidates.add(adder);
            }
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (Accessor)candidates.get(0);
        }
        for (Accessor candidate : candidates) {
            String elementName = Executables.getElementNameForAdder(candidate);
            if (elementName == null || !elementName.equals(Nouns.singularize(pluralPropertyName))) continue;
            return candidate;
        }
        return null;
    }

    private List<Accessor> getSetters() {
        if (this.setters == null) {
            this.setters = Collections.unmodifiableList(Filters.setterMethodsIn(this.getAllAccessors()));
        }
        return this.setters;
    }

    private List<Accessor> getAdders() {
        if (this.adders == null) {
            this.adders = Collections.unmodifiableList(Filters.adderMethodsIn(this.getAllAccessors()));
        }
        return this.adders;
    }

    private List<Accessor> getAlternativeTargetAccessors() {
        if (this.alternativeTargetAccessors == null) {
            ArrayList<Accessor> result = new ArrayList<Accessor>();
            List<Accessor> setterMethods = this.getSetters();
            ArrayList<Accessor> readAccessors = new ArrayList<Accessor>(this.getPropertyReadAccessors().values());
            readAccessors.addAll(Filters.fieldsIn(this.getAllAccessors()));
            for (Accessor readAccessor : readAccessors) {
                if (this.isCollectionOrMap(readAccessor) && !this.correspondingSetterMethodExists(readAccessor, setterMethods)) {
                    result.add(readAccessor);
                    continue;
                }
                if (!Executables.isFieldAccessor(readAccessor) || this.correspondingSetterMethodExists(readAccessor, setterMethods)) continue;
                result.add(readAccessor);
            }
            this.alternativeTargetAccessors = Collections.unmodifiableList(result);
        }
        return this.alternativeTargetAccessors;
    }

    private boolean correspondingSetterMethodExists(Accessor getterMethod, List<Accessor> setterMethods) {
        String getterPropertyName = Executables.getPropertyName(getterMethod);
        for (Accessor setterMethod : setterMethods) {
            String setterPropertyName = Executables.getPropertyName(setterMethod);
            if (!getterPropertyName.equals(setterPropertyName)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollectionOrMap(Accessor getterMethod) {
        return this.isCollection(getterMethod.getAccessedType()) || this.isMap(getterMethod.getAccessedType());
    }

    private boolean isCollection(TypeMirror candidate) {
        return this.isSubType(candidate, Collection.class);
    }

    private boolean isMap(TypeMirror candidate) {
        return this.isSubType(candidate, Map.class);
    }

    private boolean isSubType(TypeMirror candidate, Class<?> clazz) {
        String className = clazz.getCanonicalName();
        TypeMirror classType = this.typeUtils.erasure(this.elementUtils.getTypeElement(className).asType());
        return this.typeUtils.isSubtype(candidate, classType);
    }

    public int distanceTo(Type assignableOther) {
        return this.distanceTo(this.typeMirror, assignableOther.typeMirror);
    }

    private int distanceTo(TypeMirror base, TypeMirror targetType) {
        if (this.typeUtils.isSameType(base, targetType)) {
            return 0;
        }
        if (!this.typeUtils.isAssignable(base, targetType)) {
            return -1;
        }
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(base);
        int minDistanceOfSuperToTargetType = Integer.MAX_VALUE;
        for (TypeMirror typeMirror : directSupertypes) {
            int distanceToTargetType = this.distanceTo(typeMirror, targetType);
            if (distanceToTargetType < 0) continue;
            minDistanceOfSuperToTargetType = Math.min(minDistanceOfSuperToTargetType, distanceToTargetType);
        }
        return 1 + minDistanceOfSuperToTargetType;
    }

    public boolean canAccess(Type type, ExecutableElement method) {
        if (method.getModifiers().contains((Object)Modifier.PRIVATE)) {
            return false;
        }
        if (method.getModifiers().contains((Object)Modifier.PROTECTED)) {
            return this.isAssignableTo(type) || this.getPackageName().equals(type.getPackageName());
        }
        if (!method.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return this.getPackageName().equals(type.getPackageName());
        }
        return true;
    }

    public String getNull() {
        if (!this.isPrimitive() || this.isArrayType()) {
            return "null";
        }
        if ("boolean".equals(this.getName())) {
            return "false";
        }
        if ("byte".equals(this.getName())) {
            return "0";
        }
        if ("char".equals(this.getName())) {
            return "0";
        }
        if ("double".equals(this.getName())) {
            return "0.0d";
        }
        if ("float".equals(this.getName())) {
            return "0.0f";
        }
        if ("int".equals(this.getName())) {
            return "0";
        }
        if ("long".equals(this.getName())) {
            return "0L";
        }
        if ("short".equals(this.getName())) {
            return "0";
        }
        throw new UnsupportedOperationException(this.getName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Type other = (Type)obj;
        return this.typeUtils.isSameType(this.typeMirror, other.typeMirror);
    }

    @Override
    public int compareTo(Type o) {
        return this.getFullyQualifiedName().compareTo(o.getFullyQualifiedName());
    }

    public String toString() {
        return this.typeMirror.toString();
    }

    public String getIdentification() {
        if (this.isArrayType()) {
            return this.componentType.getName() + "Array";
        }
        return this.getTypeBound().getName();
    }

    public Type getTypeBound() {
        if (this.boundingBase != null) {
            return this.boundingBase;
        }
        this.boundingBase = this.typeFactory.getType(this.typeFactory.getTypeBound(this.getTypeMirror()));
        return this.boundingBase;
    }

    public boolean hasEmptyAccessibleContructor() {
        if (this.hasEmptyAccessibleContructor == null) {
            this.hasEmptyAccessibleContructor = false;
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(this.typeElement.getEnclosedElements());
            for (ExecutableElement constructor : constructors) {
                if (!constructor.getModifiers().contains((Object)Modifier.PUBLIC) && !constructor.getModifiers().contains((Object)Modifier.PROTECTED) || !constructor.getParameters().isEmpty()) continue;
                this.hasEmptyAccessibleContructor = true;
                break;
            }
        }
        return this.hasEmptyAccessibleContructor;
    }

    public List<Type> determineTypeArguments(Class<?> superclass) {
        if (this.qualifiedName.equals(superclass.getName())) {
            return this.getTypeParameters();
        }
        List<? extends TypeMirror> directSupertypes = this.typeUtils.directSupertypes(this.typeMirror);
        for (TypeMirror typeMirror : directSupertypes) {
            Type supertype = this.typeFactory.getType(typeMirror);
            List<Type> supertypeTypeArguments = supertype.determineTypeArguments(superclass);
            if (supertypeTypeArguments == null) continue;
            return supertypeTypeArguments;
        }
        return null;
    }
}

