/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.DeclaredType;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.model.LifecycleCallbackFactory;
import org.mapstruct.ap.internal.model.LifecycleCallbackMethodReference;
import org.mapstruct.ap.internal.model.MappingBuilderContext;
import org.mapstruct.ap.internal.model.MethodReference;
import org.mapstruct.ap.internal.model.NestedTargetPropertyMappingHolder;
import org.mapstruct.ap.internal.model.NormalTypeMappingMethod;
import org.mapstruct.ap.internal.model.PropertyMapping;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.dependency.GraphAnalyzer;
import org.mapstruct.ap.internal.model.source.ForgedMethod;
import org.mapstruct.ap.internal.model.source.ForgedMethodHistory;
import org.mapstruct.ap.internal.model.source.Mapping;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.PropertyEntry;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.SourceReference;
import org.mapstruct.ap.internal.model.source.TargetReference;
import org.mapstruct.ap.internal.prism.BeanMappingPrism;
import org.mapstruct.ap.internal.prism.CollectionMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.internal.prism.ReportingPolicyPrism;
import org.mapstruct.ap.internal.util.Collections;
import org.mapstruct.ap.internal.util.MapperConfiguration;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.Strings;
import org.mapstruct.ap.internal.util.accessor.Accessor;
import org.mapstruct.ap.internal.util.accessor.ExecutableElementAccessor;

public class BeanMappingMethod
extends NormalTypeMappingMethod {
    private final List<PropertyMapping> propertyMappings;
    private final Map<String, List<PropertyMapping>> mappingsByParameter;
    private final List<PropertyMapping> constantMappings;
    private final Type resultType;

    private BeanMappingMethod(Method method, Collection<String> existingVariableNames, List<PropertyMapping> propertyMappings, MethodReference factoryMethod, boolean mapNullToDefault, Type resultType, List<LifecycleCallbackMethodReference> beforeMappingReferences, List<LifecycleCallbackMethodReference> afterMappingReferences) {
        super(method, existingVariableNames, factoryMethod, mapNullToDefault, beforeMappingReferences, afterMappingReferences);
        this.propertyMappings = propertyMappings;
        this.mappingsByParameter = new HashMap<String, List<PropertyMapping>>();
        this.constantMappings = new ArrayList<PropertyMapping>(propertyMappings);
        for (Parameter sourceParameter : this.getSourceParameters()) {
            ArrayList<PropertyMapping> mappingsOfParameter = new ArrayList<PropertyMapping>();
            this.mappingsByParameter.put(sourceParameter.getName(), mappingsOfParameter);
            for (PropertyMapping mapping : propertyMappings) {
                if (!sourceParameter.getName().equals(mapping.getSourceBeanName())) continue;
                mappingsOfParameter.add(mapping);
                this.constantMappings.remove(mapping);
            }
        }
        this.resultType = resultType;
    }

    public List<PropertyMapping> getPropertyMappings() {
        return this.propertyMappings;
    }

    public List<PropertyMapping> getConstantMappings() {
        return this.constantMappings;
    }

    public Map<String, List<PropertyMapping>> getPropertyMappingsByParameter() {
        return this.mappingsByParameter;
    }

    @Override
    public Type getResultType() {
        if (this.resultType == null) {
            return super.getResultType();
        }
        return this.resultType;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        for (PropertyMapping propertyMapping : this.propertyMappings) {
            types.addAll(propertyMapping.getImportTypes());
        }
        return types;
    }

    public List<Parameter> getSourceParametersExcludingPrimitives() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    public List<Parameter> getSourcePrimitiveParameters() {
        ArrayList<Parameter> sourceParameters = new ArrayList<Parameter>();
        for (Parameter sourceParam : this.getSourceParameters()) {
            if (!sourceParam.getType().isPrimitive()) continue;
            sourceParameters.add(sourceParam);
        }
        return sourceParameters;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BeanMappingMethod that = (BeanMappingMethod)obj;
        if (!super.equals(obj)) {
            return false;
        }
        return this.propertyMappings != null ? this.propertyMappings.equals(that.propertyMappings) : that.propertyMappings == null;
    }

    private static class SourceMethodSingleMapping
    implements SingleMappingByTargetPropertyNameFunction {
        private final SourceMethod sourceMethod;

        private SourceMethodSingleMapping(SourceMethod sourceMethod) {
            this.sourceMethod = sourceMethod;
        }

        @Override
        public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
            return this.sourceMethod.getSingleMappingByTargetPropertyName(targetPropertyName);
        }
    }

    private static class EmptySingleMapping
    implements SingleMappingByTargetPropertyNameFunction {
        private EmptySingleMapping() {
        }

        @Override
        public Mapping getSingleMappingByTargetPropertyName(String targetPropertyName) {
            return null;
        }
    }

    private static interface SingleMappingByTargetPropertyNameFunction {
        public Mapping getSingleMappingByTargetPropertyName(String var1);
    }

    public static class Builder {
        private MappingBuilderContext ctx;
        private Method method;
        private Map<String, Accessor> unprocessedTargetProperties;
        private Set<String> targetProperties;
        private final List<PropertyMapping> propertyMappings = new ArrayList<PropertyMapping>();
        private final Set<Parameter> unprocessedSourceParameters = new HashSet<Parameter>();
        private NullValueMappingStrategyPrism nullValueMappingStrategy;
        private SelectionParameters selectionParameters;
        private final Set<String> existingVariableNames = new HashSet<String>();
        private Map<String, List<Mapping>> methodMappings;
        private SingleMappingByTargetPropertyNameFunction singleMapping;
        private final Map<String, List<Mapping>> unprocessedDefinedTargets = new HashMap<String, List<Mapping>>();

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder souceMethod(SourceMethod sourceMethod) {
            this.singleMapping = new SourceMethodSingleMapping(sourceMethod);
            return this.setupMethodWithMapping(sourceMethod);
        }

        public Builder forgedMethod(Method method) {
            this.singleMapping = new EmptySingleMapping();
            return this.setupMethodWithMapping(method);
        }

        private Builder setupMethodWithMapping(Method sourceMethod) {
            this.method = sourceMethod;
            this.methodMappings = sourceMethod.getMappingOptions().getMappings();
            CollectionMappingStrategyPrism cms = sourceMethod.getMapperConfiguration().getCollectionMappingStrategy();
            Map<String, Accessor> accessors = this.method.getResultType().getPropertyWriteAccessors(cms);
            this.targetProperties = accessors.keySet();
            this.unprocessedTargetProperties = new LinkedHashMap<String, Accessor>(accessors);
            for (Parameter sourceParameter : this.method.getSourceParameters()) {
                this.unprocessedSourceParameters.add(sourceParameter);
            }
            this.existingVariableNames.addAll(this.method.getParameterNames());
            return this;
        }

        public Builder selectionParameters(SelectionParameters selectionParameters) {
            this.selectionParameters = selectionParameters;
            return this;
        }

        public Builder nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        public BeanMappingMethod build() {
            boolean mappingErrorOccured = this.handleDefinedMappings();
            if (mappingErrorOccured) {
                return null;
            }
            if (!this.method.getMappingOptions().isRestrictToDefinedMappings()) {
                this.applyPropertyNameBasedMapping();
                this.applyParameterNameBasedMapping();
            }
            this.handleUnprocessedDefinedTargets();
            this.reportErrorForUnmappedTargetPropertiesIfRequired();
            boolean mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
            BeanMappingPrism beanMappingPrism = BeanMappingPrism.getInstanceOn(this.method.getExecutable());
            MethodReference factoryMethod = null;
            if (!this.method.isUpdateMethod()) {
                factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, this.method.getResultType(), this.selectionParameters);
            }
            Type resultType = null;
            if (factoryMethod == null) {
                if (this.selectionParameters != null && this.selectionParameters.getResultType() != null) {
                    resultType = this.ctx.getTypeFactory().getType(this.selectionParameters.getResultType());
                    if (resultType.isAbstract()) {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), beanMappingPrism.mirror, Message.BEANMAPPING_ABSTRACT, resultType, this.method.getResultType());
                    } else if (!resultType.isAssignableTo(this.method.getResultType())) {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), beanMappingPrism.mirror, Message.BEANMAPPING_NOT_ASSIGNABLE, resultType, this.method.getResultType());
                    }
                } else if (!this.method.isUpdateMethod() && this.method.getReturnType().isAbstract()) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.GENERAL_ABSTRACT_RETURN_TYPE, this.method.getReturnType());
                }
            }
            this.sortPropertyMappingsByDependencies();
            List<LifecycleCallbackMethodReference> beforeMappingMethods = LifecycleCallbackFactory.beforeMappingMethods(this.method, this.selectionParameters, this.ctx, this.existingVariableNames);
            List<LifecycleCallbackMethodReference> afterMappingMethods = LifecycleCallbackFactory.afterMappingMethods(this.method, this.selectionParameters, this.ctx, this.existingVariableNames);
            return new BeanMappingMethod(this.method, this.existingVariableNames, this.propertyMappings, factoryMethod, mapNullToDefault, resultType, beforeMappingMethods, afterMappingMethods);
        }

        private void handleUnprocessedDefinedTargets() {
            Iterator<Map.Entry<String, List<Mapping>>> iterator = this.unprocessedDefinedTargets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<Mapping>> entry = iterator.next();
                String propertyName = entry.getKey();
                if (!this.unprocessedTargetProperties.containsKey(propertyName)) continue;
                List<Parameter> sourceParameters = this.method.getSourceParameters();
                boolean forceUpdateMethod = sourceParameters.size() > 1;
                for (Parameter sourceParameter : sourceParameters) {
                    SourceReference reference = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(propertyName).build();
                    MappingOptions mappingOptions = this.extractAdditionalOptions(propertyName, true);
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(this.unprocessedTargetProperties.get(propertyName))).targetReadAccessor(this.getTargetPropertyReadAccessor(propertyName))).targetPropertyName(propertyName)).sourceReference(reference).existingVariableNames(this.existingVariableNames)).dependsOn(mappingOptions.collectNestedDependsOn())).forgeMethodWithMappingOptions(mappingOptions).forceUpdateMethod(forceUpdateMethod).forgedNamedBased(false).build();
                    if (propertyMapping == null) continue;
                    this.unprocessedTargetProperties.remove(propertyName);
                    iterator.remove();
                    this.propertyMappings.add(propertyMapping);
                }
            }
        }

        private void sortPropertyMappingsByDependencies() {
            GraphAnalyzer.GraphAnalyzerBuilder graphAnalyzerBuilder = GraphAnalyzer.builder();
            for (PropertyMapping propertyMapping : this.propertyMappings) {
                graphAnalyzerBuilder.withNode(propertyMapping.getName(), propertyMapping.getDependsOn());
            }
            final GraphAnalyzer graphAnalyzer = graphAnalyzerBuilder.build();
            if (!graphAnalyzer.getCycles().isEmpty()) {
                HashSet<String> cycles = new HashSet<String>();
                for (List<String> cycle : graphAnalyzer.getCycles()) {
                    cycles.add(Strings.join(cycle, " -> "));
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_CYCLE_BETWEEN_PROPERTIES, Strings.join(cycles, ", "));
            } else {
                java.util.Collections.sort(this.propertyMappings, new Comparator<PropertyMapping>(){

                    @Override
                    public int compare(PropertyMapping o1, PropertyMapping o2) {
                        return graphAnalyzer.getTraversalSequence(o1.getName()) - graphAnalyzer.getTraversalSequence(o2.getName());
                    }
                });
            }
        }

        private boolean handleDefinedMappings() {
            boolean errorOccurred = false;
            HashSet<String> handledTargets = new HashSet<String>();
            if (this.method.getMappingOptions().hasNestedTargetReferences()) {
                this.handleDefinedNestedTargetMapping(handledTargets);
            }
            for (Map.Entry<String, List<Mapping>> entry : this.methodMappings.entrySet()) {
                for (Mapping mapping : entry.getValue()) {
                    TargetReference targetReference = mapping.getTargetReference();
                    if (targetReference.isValid()) {
                        if (handledTargets.contains(Collections.first(targetReference.getPropertyEntries()).getFullName()) || !this.handleDefinedMapping(mapping, handledTargets)) continue;
                        errorOccurred = true;
                        continue;
                    }
                    if (!this.reportErrorOnTargetObject(mapping)) continue;
                    errorOccurred = true;
                }
            }
            for (String handledTarget : handledTargets) {
                this.unprocessedTargetProperties.remove(handledTarget);
                this.unprocessedDefinedTargets.remove(handledTarget);
            }
            return errorOccurred;
        }

        private void handleDefinedNestedTargetMapping(Set<String> handledTargets) {
            NestedTargetPropertyMappingHolder holder = new NestedTargetPropertyMappingHolder.Builder().mappingContext(this.ctx).method(this.method).existingVariableNames(this.existingVariableNames).build();
            this.unprocessedSourceParameters.removeAll(holder.getProcessedSourceParameters());
            this.propertyMappings.addAll(holder.getPropertyMappings());
            handledTargets.addAll(holder.getHandledTargets());
            for (Map.Entry<PropertyEntry, List<Mapping>> entry : holder.getUnprocessedDefinedTarget().entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                this.unprocessedDefinedTargets.put(entry.getKey().getName(), entry.getValue());
            }
        }

        private boolean handleDefinedMapping(Mapping mapping, Set<String> handledTargets) {
            boolean errorOccured = false;
            PropertyMapping propertyMapping = null;
            TargetReference targetRef = mapping.getTargetReference();
            PropertyEntry targetProperty = Collections.first(targetRef.getPropertyEntries());
            String propertyName = targetProperty.getName();
            for (String dependency : mapping.getDependsOn()) {
                if (this.targetProperties.contains(dependency)) continue;
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getDependsOnAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_DEPENDS_ON, dependency);
                errorOccured = true;
            }
            if (mapping.isIgnored()) {
                propertyMapping = null;
                handledTargets.add(mapping.getTargetName());
            } else if (mapping.getSourceName() != null) {
                SourceReference sourceRef = mapping.getSourceReference();
                if (sourceRef.isValid()) {
                    propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).sourceReference(sourceRef).selectionParameters(mapping.getSelectionParameters()).formattingParameters(mapping.getFormattingParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).defaultValue(mapping.getDefaultValue()).build();
                    handledTargets.add(propertyName);
                    this.unprocessedSourceParameters.remove(sourceRef.getParameter());
                } else {
                    errorOccured = true;
                }
            } else if (mapping.getConstant() != null && !this.unprocessedDefinedTargets.containsKey(propertyName)) {
                propertyMapping = ((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)((PropertyMapping.ConstantMappingBuilder)new PropertyMapping.ConstantMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).constantExpression("\"" + mapping.getConstant() + "\"").targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).formattingParameters(mapping.getFormattingParameters()).selectionParameters(mapping.getSelectionParameters()).existingVariableNames(this.existingVariableNames)).dependsOn(mapping.getDependsOn())).build();
                handledTargets.add(mapping.getTargetName());
            } else if (mapping.getJavaExpression() != null && !this.unprocessedDefinedTargets.containsKey(propertyName)) {
                propertyMapping = ((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)((PropertyMapping.JavaExpressionMappingBuilder)new PropertyMapping.JavaExpressionMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).javaExpression(mapping.getJavaExpression()).existingVariableNames(this.existingVariableNames)).targetProperty(targetProperty)).targetPropertyName(mapping.getTargetName())).dependsOn(mapping.getDependsOn())).build();
                handledTargets.add(mapping.getTargetName());
            }
            if (propertyMapping != null) {
                this.propertyMappings.add(propertyMapping);
            }
            return errorOccured;
        }

        private boolean reportErrorOnTargetObject(Mapping mapping) {
            boolean errorOccurred = false;
            boolean hasReadAccessor = this.method.getResultType().getPropertyReadAccessors().containsKey(mapping.getTargetName());
            if (hasReadAccessor) {
                if (!mapping.isIgnored()) {
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getSourceAnnotationValue(), Message.BEANMAPPING_PROPERTY_HAS_NO_WRITE_ACCESSOR_IN_RESULTTYPE, mapping.getTargetName());
                    errorOccurred = true;
                }
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), mapping.getMirror(), mapping.getSourceAnnotationValue(), Message.BEANMAPPING_UNKNOWN_PROPERTY_IN_RESULTTYPE, mapping.getTargetName());
                errorOccurred = true;
            }
            return errorOccurred;
        }

        private void applyPropertyNameBasedMapping() {
            Iterator<Map.Entry<String, Accessor>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, Accessor> targetProperty = targetPropertyEntriesIterator.next();
                String targetPropertyName = targetProperty.getKey();
                PropertyMapping propertyMapping = null;
                if (propertyMapping == null) {
                    for (Parameter sourceParameter : this.method.getSourceParameters()) {
                        Type sourceType = sourceParameter.getType();
                        if (sourceType.isPrimitive()) continue;
                        PropertyMapping newPropertyMapping = null;
                        Accessor sourceReadAccessor = sourceParameter.getType().getPropertyReadAccessors().get(targetPropertyName);
                        ExecutableElementAccessor sourcePresenceChecker = sourceParameter.getType().getPropertyPresenceCheckers().get(targetPropertyName);
                        if (sourceReadAccessor != null) {
                            Mapping mapping = this.singleMapping.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                            DeclaredType declaredSourceType = (DeclaredType)sourceParameter.getType().getTypeMirror();
                            SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).type(this.ctx.getTypeFactory().getReturnType(declaredSourceType, sourceReadAccessor)).readAccessor(sourceReadAccessor).presenceChecker(sourcePresenceChecker).name(targetProperty.getKey()).build();
                            newPropertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetPropertyName))).targetPropertyName(targetPropertyName)).sourceReference(sourceRef).formattingParameters(mapping != null ? mapping.getFormattingParameters() : null).selectionParameters(mapping != null ? mapping.getSelectionParameters() : null).defaultValue(mapping != null ? mapping.getDefaultValue() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : java.util.Collections.emptyList())).forgeMethodWithMappingOptions(this.extractAdditionalOptions(targetPropertyName, false)).build();
                            this.unprocessedSourceParameters.remove(sourceParameter);
                        }
                        if (propertyMapping != null && newPropertyMapping != null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.BEANMAPPING_SEVERAL_POSSIBLE_SOURCES, targetPropertyName);
                            break;
                        }
                        if (newPropertyMapping == null) continue;
                        propertyMapping = newPropertyMapping;
                    }
                }
                if (propertyMapping == null) continue;
                this.propertyMappings.add(propertyMapping);
                targetPropertyEntriesIterator.remove();
                this.unprocessedDefinedTargets.remove(targetPropertyName);
            }
        }

        private void applyParameterNameBasedMapping() {
            Iterator<Map.Entry<String, Accessor>> targetPropertyEntriesIterator = this.unprocessedTargetProperties.entrySet().iterator();
            while (targetPropertyEntriesIterator.hasNext()) {
                Map.Entry<String, Accessor> targetProperty = targetPropertyEntriesIterator.next();
                Iterator<Parameter> sourceParameters = this.unprocessedSourceParameters.iterator();
                while (sourceParameters.hasNext()) {
                    Parameter sourceParameter = sourceParameters.next();
                    if (!sourceParameter.getName().equals(targetProperty.getKey())) continue;
                    Mapping mapping = this.singleMapping.getSingleMappingByTargetPropertyName(targetProperty.getKey());
                    SourceReference sourceRef = new SourceReference.BuilderFromProperty().sourceParameter(sourceParameter).name(targetProperty.getKey()).build();
                    PropertyMapping propertyMapping = ((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)((PropertyMapping.PropertyMappingBuilder)new PropertyMapping.PropertyMappingBuilder().mappingContext(this.ctx)).sourceMethod(this.method)).targetWriteAccessor(targetProperty.getValue())).targetReadAccessor(this.getTargetPropertyReadAccessor(targetProperty.getKey()))).targetPropertyName(targetProperty.getKey())).sourceReference(sourceRef).formattingParameters(mapping != null ? mapping.getFormattingParameters() : null).selectionParameters(mapping != null ? mapping.getSelectionParameters() : null).existingVariableNames(this.existingVariableNames)).dependsOn(mapping != null ? mapping.getDependsOn() : java.util.Collections.emptyList())).forgeMethodWithMappingOptions(this.extractAdditionalOptions(targetProperty.getKey(), false)).build();
                    this.propertyMappings.add(propertyMapping);
                    targetPropertyEntriesIterator.remove();
                    sourceParameters.remove();
                    this.unprocessedDefinedTargets.remove(targetProperty.getKey());
                }
            }
        }

        private MappingOptions extractAdditionalOptions(String targetProperty, boolean restrictToDefinedMappings) {
            MappingOptions additionalOptions = null;
            if (this.unprocessedDefinedTargets.containsKey(targetProperty)) {
                HashMap<String, List<Mapping>> mappings = new HashMap<String, List<Mapping>>();
                mappings.put(targetProperty, this.unprocessedDefinedTargets.get(targetProperty));
                additionalOptions = MappingOptions.forMappingsOnly(mappings, restrictToDefinedMappings);
            }
            return additionalOptions;
        }

        private Accessor getTargetPropertyReadAccessor(String propertyName) {
            return this.method.getResultType().getPropertyReadAccessors().get(propertyName);
        }

        private ReportingPolicyPrism getUnmappedTargetPolicy() {
            MappingOptions mappingOptions = this.method.getMappingOptions();
            if (mappingOptions.getBeanMapping() != null && mappingOptions.getBeanMapping().getReportingPolicy() != null) {
                return mappingOptions.getBeanMapping().getReportingPolicy();
            }
            MapperConfiguration mapperSettings = MapperConfiguration.getInstanceOn(this.ctx.getMapperTypeElement());
            return mapperSettings.unmappedTargetPolicy(this.ctx.getOptions());
        }

        private void reportErrorForUnmappedTargetPropertiesIfRequired() {
            ReportingPolicyPrism unmappedTargetPolicy = this.getUnmappedTargetPolicy();
            if (this.method instanceof ForgedMethod && this.targetProperties.isEmpty()) {
                ForgedMethod forgedMethod = (ForgedMethod)this.method;
                if (forgedMethod.getHistory() == null) {
                    Type sourceType = this.method.getParameters().get(0).getType();
                    Type targetType = this.method.getReturnType();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_FORGED_MAPPING_NOT_FOUND, sourceType, targetType, targetType, sourceType);
                } else {
                    ForgedMethodHistory history = forgedMethod.getHistory();
                    this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_MAPPING_NOT_FOUND, history.createSourcePropertyErrorMessage(), history.getTargetType(), history.createTargetPropertyName(), history.getTargetType(), history.getSourceType());
                }
            } else if (!this.unprocessedTargetProperties.isEmpty() && unmappedTargetPolicy.requiresReport()) {
                Message msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_TARGETS_WARNING;
                Object[] args = new Object[]{MessageFormat.format("{0,choice,1#property|1<properties}: \"{1}\"", this.unprocessedTargetProperties.size(), Strings.join(this.unprocessedTargetProperties.keySet(), ", "))};
                if (this.method instanceof ForgedMethod) {
                    msg = unmappedTargetPolicy.getDiagnosticKind() == Diagnostic.Kind.ERROR ? Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_ERROR : Message.BEANMAPPING_UNMAPPED_FORGED_TARGETS_WARNING;
                    String sourceErrorMessage = this.method.getParameters().get(0).getType().toString();
                    String targetErrorMessage = this.method.getReturnType().toString();
                    if (((ForgedMethod)this.method).getHistory() != null) {
                        ForgedMethodHistory history = ((ForgedMethod)this.method).getHistory();
                        sourceErrorMessage = history.createSourcePropertyErrorMessage();
                        targetErrorMessage = MessageFormat.format("\"{0} {1}\"", history.getTargetType(), history.createTargetPropertyName());
                    }
                    args = new Object[]{args[0], sourceErrorMessage, targetErrorMessage};
                }
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), msg, args);
            }
        }
    }
}

