/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.configuration.HubConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseMojo;
import org.liquibase.maven.plugins.MavenResourceAccessor;

public abstract class AbstractLiquibaseChangeLogMojo
extends AbstractLiquibaseMojo {
    protected String changeLogDirectory;
    protected String changeLogFile;
    protected String contexts;
    protected String labels;
    protected String hubApiKey;
    protected String hubUrl;
    protected String hubMode;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.changeLogFile == null) {
            throw new MojoFailureException("The changeLogFile must be specified.");
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        HubConfiguration hubConfiguration = (HubConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(HubConfiguration.class);
        if (StringUtil.isNotEmpty((String)this.hubApiKey)) {
            hubConfiguration.setLiquibaseHubApiKey(this.hubApiKey);
        }
        if (StringUtil.isNotEmpty((String)this.hubUrl)) {
            hubConfiguration.setLiquibaseHubUrl(this.hubUrl);
        }
        if (StringUtil.isNotEmpty((String)this.hubMode)) {
            hubConfiguration.setLiquibaseHubMode(this.hubMode);
        }
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "changeLogDirectory: " + this.changeLogDirectory));
        this.getLog().info((CharSequence)(indent + "changeLogFile: " + this.changeLogFile));
        this.getLog().info((CharSequence)(indent + "context(s): " + this.contexts));
        this.getLog().info((CharSequence)(indent + "label(s): " + this.labels));
    }

    @Override
    protected ResourceAccessor getResourceAccessor(ClassLoader cl) {
        ArrayList<Object> resourceAccessors = new ArrayList<Object>();
        resourceAccessors.add((Object)new MavenResourceAccessor(cl));
        resourceAccessors.add(new FileSystemResourceAccessor(new File[]{this.project.getBasedir()}));
        resourceAccessors.add(new ClassLoaderResourceAccessor(((Object)((Object)this)).getClass().getClassLoader()));
        if (this.changeLogDirectory != null) {
            this.calculateChangeLogDirectoryAbsolutePath();
            resourceAccessors.add(new FileSystemResourceAccessor(new File[]{new File(this.changeLogDirectory)}));
        }
        return new CompositeResourceAccessor(resourceAccessors);
    }

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        String changeLog = this.changeLogFile == null ? "" : this.changeLogFile.trim();
        return new Liquibase(changeLog, Scope.getCurrentScope().getResourceAccessor(), db);
    }

    private void calculateChangeLogDirectoryAbsolutePath() {
        if (this.changeLogDirectory != null) {
            this.changeLogDirectory = this.changeLogDirectory.trim().replace('\\', '/');
            File changeLogDirectoryFile = new File(this.changeLogDirectory);
            if (!changeLogDirectoryFile.isAbsolute()) {
                this.changeLogDirectory = this.project.getBasedir().getAbsolutePath().replace('\\', '/') + "/" + this.changeLogDirectory;
            }
        }
    }
}

