/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;

public class LiquibaseDatabaseDiff
extends AbstractLiquibaseChangeLogMojo {
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultSchemaName;
    private String referenceServer;
    protected String diffChangeLogFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        AuthenticationInfo referenceInfo = this.wagonManager.getAuthenticationInfo(this.referenceServer);
        if (referenceInfo != null) {
            this.referenceUsername = referenceInfo.getUserName();
            this.referencePassword = referenceInfo.getPassword();
        }
        super.execute();
    }

    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        ClassLoader cl = null;
        try {
            cl = this.getClassLoaderIncludingProjectClasspath();
            Thread.currentThread().setContextClassLoader(cl);
        }
        catch (MojoExecutionException e) {
            throw new LiquibaseException("Could not create the class loader, " + (Object)((Object)e), (Throwable)e);
        }
        Database db = liquibase.getDatabase();
        Database referenceDatabase = CommandLineUtils.createDatabaseObject((ClassLoader)cl, (String)this.referenceUrl, (String)this.referenceUsername, (String)this.referencePassword, (String)this.referenceDriver, (String)this.referenceDefaultSchemaName, null, null);
        this.getLog().info((CharSequence)("Performing Diff on database " + db.toString()));
        if (this.diffChangeLogFile != null) {
            try {
                CommandLineUtils.doDiffToChangeLog((String)this.diffChangeLogFile, (Database)referenceDatabase, (Database)db);
                this.getLog().info((CharSequence)("Differences written to Change Log File, " + this.diffChangeLogFile));
            }
            catch (IOException e) {
                throw new LiquibaseException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new LiquibaseException((Throwable)e);
            }
        } else {
            CommandLineUtils.doDiff((Database)referenceDatabase, (Database)db);
        }
    }

    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "referenceDriver: " + this.referenceDriver));
        this.getLog().info((CharSequence)(indent + "referenceUrl: " + this.referenceUrl));
        this.getLog().info((CharSequence)(indent + "referenceUsername: " + this.referenceUsername));
        this.getLog().info((CharSequence)(indent + "referencePassword: " + this.referencePassword));
        this.getLog().info((CharSequence)(indent + "referenceDefaultSchema: " + this.referenceDefaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffChangeLogFile: " + this.diffChangeLogFile));
    }

    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.referenceUrl == null) {
            throw new MojoFailureException("A reference database or hibernate configuration file must be provided to perform a diff.");
        }
        if (this.referencePassword == null) {
            this.referencePassword = "";
        }
    }

    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }
}

