/*
 * Decompiled with CFR 0.152.
 */
package org.kubek2k.springockito.annotations.internal.factory;

import org.kubek2k.springockito.annotations.internal.ResettableMock;
import org.mockito.Answers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.internal.creation.MockSettingsImpl;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFactoryBean<T>
implements FactoryBean<T>,
ResettableMock {
    private Class<T> mockClass;
    private final Class[] extraInterfaces;
    private final String mockName;
    private final Answers defaultAnswer;
    private T instance;

    public MockFactoryBean(Class<T> mockClass, Class[] extraInterfaces, String mockName, Answers defaultAnswer) {
        this.mockClass = mockClass;
        this.extraInterfaces = extraInterfaces;
        this.mockName = mockName;
        this.defaultAnswer = defaultAnswer;
    }

    public Class<? extends T> getObjectType() {
        return this.mockClass;
    }

    public boolean isSingleton() {
        return true;
    }

    public T getObject() throws Exception {
        if (this.instance == null) {
            this.instance = this.createInstance();
        }
        return this.instance;
    }

    private T createInstance() {
        MockSettingsImpl mockSettings = new MockSettingsImpl();
        if (this.extraInterfaces.length > 0) {
            mockSettings = mockSettings.extraInterfaces(this.extraInterfaces);
        }
        if (this.defaultAnswer != null) {
            mockSettings = mockSettings.defaultAnswer(this.defaultAnswer.get());
        }
        if (this.mockName != null) {
            mockSettings = mockSettings.name(this.mockName);
        }
        return (T)Mockito.mock(this.mockClass, (MockSettings)mockSettings);
    }

    @Override
    public void resetMock() {
        Object object = null;
        try {
            object = this.getObject();
            Mockito.reset((Object[])new Object[]{object});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

