/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.keys.AbstractEddsaKeyProvider;
import org.keycloak.models.RealmModel;

public class GeneratedEddsaKeyProvider
extends AbstractEddsaKeyProvider {
    private static final Logger logger = Logger.getLogger(GeneratedEddsaKeyProvider.class);

    public GeneratedEddsaKeyProvider(RealmModel realm, ComponentModel model) {
        super(realm, model);
    }

    @Override
    protected KeyWrapper loadKey(RealmModel realm, ComponentModel model) {
        String privateEddsaKeyBase64Encoded = (String)model.getConfig().getFirst((Object)"eddsaPrivateKey");
        String publicEddsaKeyBase64Encoded = (String)model.getConfig().getFirst((Object)"eddsaPublicKey");
        String curveName = (String)model.getConfig().getFirst((Object)"eddsaEllipticCurveKey");
        try {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Base64.decode((String)privateEddsaKeyBase64Encoded));
            KeyFactory kf = KeyFactory.getInstance("EdDSA");
            PrivateKey decodedPrivateKey = kf.generatePrivate(privateKeySpec);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.decode((String)publicEddsaKeyBase64Encoded));
            PublicKey decodedPublicKey = kf.generatePublic(publicKeySpec);
            KeyPair keyPair = new KeyPair(decodedPublicKey, decodedPrivateKey);
            return this.createKeyWrapper(keyPair, curveName);
        }
        catch (Exception e) {
            logger.warnf("Exception at decodeEddsaPublicKey. %s", (Object)e.toString());
            return null;
        }
    }
}

