/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.cip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.keycloak.adapters.authorization.ClaimInformationPointProvider;
import org.keycloak.adapters.authorization.util.PlaceHolders;
import org.keycloak.adapters.spi.HttpFacade;

public class ClaimsInformationPointProvider
implements ClaimInformationPointProvider {
    private final Map<String, Object> config;

    public ClaimsInformationPointProvider(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public Map<String, List<String>> resolve(HttpFacade httpFacade) {
        HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
        for (Map.Entry<String, Object> configEntry : this.config.entrySet()) {
            String claimName = configEntry.getKey();
            Object claimValue = configEntry.getValue();
            List<Object> values = new ArrayList();
            if (claimValue instanceof String) {
                values = this.getValues(claimValue.toString(), httpFacade);
            } else if (claimValue instanceof Collection) {
                Iterator iterator = ((Collection)Collection.class.cast(claimValue)).iterator();
                while (iterator.hasNext()) {
                    List<String> resolvedValues = this.getValues(iterator.next().toString(), httpFacade);
                    if (resolvedValues.isEmpty()) continue;
                    values.addAll(resolvedValues);
                }
            }
            if (values.isEmpty()) continue;
            claims.put(claimName, values);
        }
        return claims;
    }

    private List<String> getValues(String value, HttpFacade httpFacade) {
        return PlaceHolders.resolve(value, httpFacade);
    }
}

