/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.surefire.provider;

import java.util.Optional;
import org.apache.maven.surefire.report.PojoStackTraceWriter;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.SimpleReportEntry;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

final class RunListenerAdapter
implements TestExecutionListener {
    private final RunListener runListener;
    private Optional<TestPlan> testPlan = Optional.empty();

    public RunListenerAdapter(RunListener runListener) {
        this.runListener = runListener;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = Optional.of(testPlan);
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = Optional.empty();
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.runListener.testStarting((ReportEntry)this.createReportEntry(testIdentifier, Optional.empty()));
        }
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        String source = this.sourceLegacyReportingName(testIdentifier);
        this.runListener.testSkipped((ReportEntry)SimpleReportEntry.ignored((String)source, (String)testIdentifier.getLegacyReportingName(), (String)reason));
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.ABORTED) {
            this.runListener.testAssumptionFailure((ReportEntry)this.createReportEntry(testIdentifier, testExecutionResult.getThrowable()));
        } else if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.reportFailedTest(testIdentifier, testExecutionResult.getThrowable());
        } else if (testIdentifier.isTest()) {
            this.runListener.testSucceeded((ReportEntry)this.createReportEntry(testIdentifier, Optional.empty()));
        }
    }

    private void reportFailedTest(TestIdentifier testIdentifier, Optional<Throwable> throwable) {
        SimpleReportEntry reportEntry = this.createReportEntry(testIdentifier, throwable);
        if (throwable.filter(AssertionError.class::isInstance).isPresent()) {
            this.runListener.testFailed((ReportEntry)reportEntry);
        } else {
            this.runListener.testError((ReportEntry)reportEntry);
        }
    }

    private SimpleReportEntry createReportEntry(TestIdentifier testIdentifier, Optional<Throwable> throwable) {
        Optional<String> className = this.getClassName(testIdentifier);
        Optional stackTraceWriter = throwable.flatMap(t -> className.map(name -> new PojoStackTraceWriter(name, this.getMethodName(testIdentifier).orElse(""), t)));
        String source = this.sourceLegacyReportingName(testIdentifier);
        return new SimpleReportEntry(source, testIdentifier.getLegacyReportingName(), (StackTraceWriter)stackTraceWriter.orElse(null), null);
    }

    private String sourceLegacyReportingName(TestIdentifier testIdentifier) {
        return this.testPlan.flatMap(plan -> plan.getParent(testIdentifier)).map(TestIdentifier::getLegacyReportingName).orElse("<unrooted>");
    }

    private Optional<String> getClassName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof ClassSource) {
            return Optional.of(((ClassSource)testSource).getJavaClass().getName());
        }
        if (testSource instanceof MethodSource) {
            return Optional.of(((MethodSource)testSource).getClassName());
        }
        return Optional.empty();
    }

    private Optional<String> getMethodName(TestIdentifier testIdentifier) {
        TestSource testSource = testIdentifier.getSource().orElse(null);
        if (testSource instanceof MethodSource) {
            return Optional.of(((MethodSource)testSource).getMethodName());
        }
        return Optional.empty();
    }
}

