/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random.randomizers.text;

import java.nio.charset.Charset;
import org.jeasy.random.EasyRandomParameters;
import org.jeasy.random.randomizers.AbstractRandomizer;
import org.jeasy.random.randomizers.text.CharacterRandomizer;

public class StringRandomizer
extends AbstractRandomizer<String> {
    private final CharacterRandomizer characterRandomizer;
    private int maxLength = EasyRandomParameters.DEFAULT_STRING_LENGTH_RANGE.getMax();
    private int minLength = EasyRandomParameters.DEFAULT_STRING_LENGTH_RANGE.getMin();

    public StringRandomizer() {
        this.characterRandomizer = new CharacterRandomizer();
    }

    public StringRandomizer(Charset charset) {
        this.characterRandomizer = new CharacterRandomizer(charset);
    }

    public StringRandomizer(int maxLength) {
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer();
    }

    public StringRandomizer(long seed) {
        super(seed);
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(Charset charset, long seed) {
        super(seed);
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public StringRandomizer(int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(int minLength, int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.characterRandomizer = new CharacterRandomizer(seed);
    }

    public StringRandomizer(Charset charset, int maxLength, long seed) {
        super(seed);
        this.maxLength = maxLength;
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    public StringRandomizer(Charset charset, int minLength, int maxLength, long seed) {
        super(seed);
        if (minLength > maxLength) {
            throw new IllegalArgumentException("minLength should be less than or equal to maxLength");
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.characterRandomizer = new CharacterRandomizer(charset, seed);
    }

    @Override
    public String getRandomValue() {
        int length = (int)this.nextDouble(this.minLength, this.maxLength);
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.characterRandomizer.getRandomValue().charValue();
        }
        return new String(chars);
    }
}

