/*
 * Decompiled with CFR 0.152.
 */
package org.jeasy.random;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.function.Predicate;
import org.jeasy.random.api.ExclusionPolicy;
import org.jeasy.random.api.RandomizerContext;
import org.jeasy.random.util.ReflectionUtils;

public class DefaultExclusionPolicy
implements ExclusionPolicy {
    @Override
    public boolean shouldBeExcluded(Field field, RandomizerContext context) {
        if (ReflectionUtils.isStatic(field)) {
            return true;
        }
        Set<Predicate<Field>> fieldExclusionPredicates = context.getParameters().getFieldExclusionPredicates();
        for (Predicate<Field> fieldExclusionPredicate : fieldExclusionPredicates) {
            if (!fieldExclusionPredicate.test(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBeExcluded(Class<?> type, RandomizerContext context) {
        Set<Predicate<Class<?>>> typeExclusionPredicates = context.getParameters().getTypeExclusionPredicates();
        for (Predicate<Class<?>> typeExclusionPredicate : typeExclusionPredicates) {
            if (!typeExclusionPredicate.test(type)) continue;
            return true;
        }
        return false;
    }
}

