/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.TypedValue;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.statement.ArgumentBinder;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.StatementContext;

public class Binding {
    protected final Map<Integer, Object> positionals = new TreeMap<Integer, Object>();
    protected final Map<String, Object> named = new LinkedHashMap<String, Object>();
    protected final List<NamedArgumentFinder> namedArgumentFinder = new ArrayList<NamedArgumentFinder>();
    private final StatementContext ctx;

    protected Binding(StatementContext ctx) {
        this.ctx = ctx;
    }

    public void addPositional(int position, Argument argument) {
        this.addPositional(position, (Object)argument);
    }

    public void addNamed(String name, Argument argument) {
        this.addNamed(name, (Object)argument);
    }

    public void addPositional(int position, Object argument) {
        this.positionals.put(position, argument);
    }

    public void addNamed(String name, Object argument) {
        this.named.put(name, argument);
    }

    public void addPositional(int position, Object argument, QualifiedType<?> type) {
        this.positionals.put(position, new TypedValue(type, argument));
    }

    public void addNamed(String name, Object argument, QualifiedType<?> type) {
        this.named.put(name, new TypedValue(type, argument));
    }

    public void addNamedArgumentFinder(NamedArgumentFinder args) {
        this.namedArgumentFinder.add(args);
    }

    @Deprecated(since="3.11.0", forRemoval=true)
    public Optional<Argument> findForName(String name, StatementContext ctx2) {
        Object found = this.named.get(name);
        if (found != null || this.named.containsKey(name)) {
            return Optional.of(new ArgumentBinder(null, ctx2, ParsedParameters.NONE).toArgument(found));
        }
        return this.namedArgumentFinder.stream().flatMap(arguments -> arguments.find(name, ctx2).stream()).findFirst();
    }

    @Deprecated(since="3.11.0", forRemoval=true)
    public Collection<String> getNames() {
        HashSet<String> names = new HashSet<String>(this.named.keySet());
        this.namedArgumentFinder.forEach(args -> names.addAll(args.getNames()));
        return Collections.unmodifiableSet(names);
    }

    @Deprecated(since="3.11.0", forRemoval=true)
    public Optional<Argument> findForPosition(int position) {
        return Optional.ofNullable(new ArgumentBinder(null, this.ctx, ParsedParameters.NONE).toArgument(this.positionals.get(position)));
    }

    public String toString() {
        return this.describe(Integer.MAX_VALUE);
    }

    public String describe(int maxLength) {
        boolean firstSection = true;
        boolean firstElem = true;
        StringBuilder buf = new StringBuilder();
        buf.append('{');
        if (!this.positionals.isEmpty()) {
            firstSection = false;
            buf.append("pos:{");
            for (Map.Entry<Integer, Object> entry : this.positionals.entrySet()) {
                if (!firstElem) {
                    buf.append(',');
                }
                firstElem = false;
                buf.append(entry.getKey()).append(':').append(ArgumentBinder.unwrap(entry.getValue()));
                if (buf.length() <= maxLength) continue;
                break;
            }
            buf.append('}');
        }
        if (!this.named.isEmpty() && buf.length() < maxLength) {
            if (!firstSection) {
                buf.append(", ");
            }
            firstSection = false;
            firstElem = true;
            buf.append("named:{");
            for (Map.Entry entry : this.named.entrySet()) {
                if (!firstElem) {
                    buf.append(',');
                }
                firstElem = false;
                buf.append((String)entry.getKey()).append(':').append(ArgumentBinder.unwrap(entry.getValue()));
                if (buf.length() <= maxLength) continue;
                break;
            }
            buf.append('}');
        }
        if (!this.namedArgumentFinder.isEmpty() && buf.length() < maxLength) {
            if (!firstSection) {
                buf.append(", ");
            }
            firstElem = true;
            buf.append("finder:[");
            for (NamedArgumentFinder namedArgumentFinder : this.namedArgumentFinder) {
                if (!firstElem) {
                    buf.append(',');
                }
                firstElem = false;
                buf.append(namedArgumentFinder);
                if (buf.length() <= maxLength) continue;
                break;
            }
            buf.append('}');
        }
        if (buf.length() > maxLength - 2) {
            buf.setLength(maxLength - 2);
            buf.append('\u2026');
        }
        return String.valueOf(buf) + "}";
    }

    public void clear() {
        this.positionals.clear();
        this.named.clear();
        this.namedArgumentFinder.clear();
    }

    public boolean isEmpty() {
        return this.positionals.isEmpty() && this.named.isEmpty() && this.namedArgumentFinder.isEmpty();
    }
}

