/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal.exceptions;

import com.google.errorprone.annotations.CheckReturnValue;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.internal.exceptions.DummyException;

public class Sneaky {
    private Sneaky() {
        throw new UtilityClassException();
    }

    @CheckReturnValue
    @Nonnull
    public static DummyException throwAnyway(Throwable t) {
        if (t instanceof Error) {
            Error e = (Error)t;
            throw e;
        }
        if (t instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)t;
            throw re;
        }
        if (t instanceof IOException) {
            IOException ioe = (IOException)t;
            throw new UncheckedIOException(ioe);
        }
        if (t instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        } else if (t instanceof InvocationTargetException) {
            throw Sneaky.throwAnyway(t.getCause());
        }
        throw (RuntimeException)Sneaky.throwEvadingChecks(t);
    }

    private static <E extends Throwable> E throwEvadingChecks(Throwable throwable) throws E {
        throw throwable;
    }
}

