/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.xml;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jbpm.JbpmException;
import org.jbpm.graph.action.ActionTypes;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.Event;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.ProcessFactory;
import org.jbpm.graph.node.StartState;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.xml.Problem;

public class JpdlXmlWriter {
    private static final String JPDL_NAMESPACE = "urn:jbpm.org:jpdl-3.2";
    private final Writer writer;
    private final List problems = new ArrayList();
    private boolean useNamespace;

    public JpdlXmlWriter(Writer writer) {
        if (writer == null) {
            throw new JbpmException("writer is null");
        }
        this.writer = writer;
    }

    public void addProblem(String msg) {
        this.problems.add(new Problem(2, msg));
    }

    public static String toString(ProcessDefinition processDefinition) {
        StringWriter stringWriter = new StringWriter();
        JpdlXmlWriter jpdlWriter = new JpdlXmlWriter(stringWriter);
        jpdlWriter.write(processDefinition);
        return stringWriter.toString();
    }

    public void setUseNamespace(boolean useNamespace) {
        this.useNamespace = useNamespace;
    }

    public void write(ProcessDefinition processDefinition) {
        if (processDefinition == null) {
            throw new JbpmException("process definition is null");
        }
        this.problems.clear();
        try {
            Document document = this.createDomTree(processDefinition);
            XMLWriter xmlWriter = new XMLWriter(this.writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
            xmlWriter.flush();
        }
        catch (IOException e) {
            Problem problem = new Problem(2, "could not write process definition", e);
            this.problems.add(problem);
        }
        if (this.problems.size() > 0) {
            throw new JpdlException(this.problems);
        }
    }

    private Document createDomTree(ProcessDefinition processDefinition) {
        Document document = DocumentHelper.createDocument();
        Element root = this.addElement((Branch)document, "process-definition");
        String value = processDefinition.getName();
        if (value != null) {
            root.addAttribute("name", value);
        }
        if (processDefinition.getStartState() != null) {
            root.addComment("START-STATE");
            this.writeStartNode(root, (StartState)processDefinition.getStartState());
        }
        if (processDefinition.getNodes() != null && processDefinition.getNodes().size() > 0) {
            root.addComment("NODES");
            this.writeNodes(root, processDefinition.getNodes());
        }
        if (processDefinition.hasEvents()) {
            root.addComment("PROCESS-EVENTS");
            this.writeEvents(root, processDefinition);
        }
        if (processDefinition.hasActions()) {
            root.addComment("ACTIONS");
            List namedProcessActions = this.getNamedProcessActions(processDefinition.getActions());
            this.writeActions(root, namedProcessActions);
        }
        return document;
    }

    private List getNamedProcessActions(Map actions) {
        ArrayList<Action> namedProcessActions = new ArrayList<Action>();
        for (Action action : actions.values()) {
            if (action.getEvent() != null || action.getName() == null) continue;
            namedProcessActions.add(action);
        }
        return namedProcessActions;
    }

    private void writeStartNode(Element element, StartState startState) {
        if (startState != null) {
            this.writeNode(this.addElement((Branch)element, this.getTypeName(startState)), startState);
        }
    }

    private void writeNodes(Element parentElement, Collection nodes) {
        for (Node node : nodes) {
            if (node instanceof StartState) continue;
            Element nodeElement = this.addElement((Branch)parentElement, ProcessFactory.getTypeName(node));
            node.write(nodeElement);
            this.writeNode(nodeElement, node);
        }
    }

    private void writeNode(Element element, Node node) {
        String value = node.getName();
        if (value != null) {
            element.addAttribute("name", value);
        }
        this.writeTransitions(element, node);
        this.writeEvents(element, node);
    }

    private void writeTransitions(Element element, Node node) {
        if (node.getLeavingTransitionsMap() != null) {
            for (Transition transition : node.getLeavingTransitionsList()) {
                this.writeTransition(element.addElement("transition"), transition);
            }
        }
    }

    private void writeTransition(Element transitionElement, Transition transition) {
        Event transitionEvent;
        if (transition.getTo() != null) {
            transitionElement.addAttribute("to", transition.getTo().getName());
        }
        if (transition.getName() != null) {
            transitionElement.addAttribute("name", transition.getName());
        }
        if ((transitionEvent = transition.getEvent("transition")) != null && transitionEvent.hasActions()) {
            this.writeActions(transitionElement, transitionEvent.getActions());
        }
    }

    private void writeEvents(Element element, GraphElement graphElement) {
        if (graphElement.hasEvents()) {
            for (Event event : graphElement.getEvents().values()) {
                this.writeEvent(element.addElement("event"), event);
            }
        }
    }

    private void writeEvent(Element eventElement, Event event) {
        eventElement.addAttribute("type", event.getEventType());
        if (event.hasActions()) {
            for (Action action : event.getActions()) {
                this.writeAction(eventElement, action);
            }
        }
    }

    private void writeActions(Element parentElement, Collection actions) {
        for (Action action : actions) {
            this.writeAction(parentElement, action);
        }
    }

    private void writeAction(Element parentElement, Action action) {
        String actionName = ActionTypes.getActionName(action.getClass());
        Element actionElement = parentElement.addElement(actionName);
        if (action.getName() != null) {
            actionElement.addAttribute("name", action.getName());
        }
        if (!action.acceptsPropagatedEvents()) {
            actionElement.addAttribute("accept-propagated-events", "false");
        }
        action.write(actionElement);
    }

    private Element addElement(Branch parent, String elementName) {
        return this.useNamespace ? parent.addElement(elementName, JPDL_NAMESPACE) : parent.addElement(elementName);
    }

    private String getTypeName(Object o) {
        return ProcessFactory.getTypeName((Node)o);
    }
}

