/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.mapper;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import org.jbpm.runtime.manager.impl.jpa.ContextMappingInfo;
import org.kie.api.runtime.manager.Context;
import org.kie.internal.process.CorrelationKey;
import org.kie.internal.process.CorrelationProperty;
import org.kie.internal.runtime.manager.Mapper;
import org.kie.internal.runtime.manager.context.CorrelationKeyContext;
import org.kie.internal.runtime.manager.context.ProcessInstanceIdContext;

public class JPAMapper
implements Mapper {
    private EntityManagerFactory emf;

    public JPAMapper(EntityManagerFactory emf) {
        this.emf = emf;
    }

    public void saveMapping(Context context, Integer ksessionId) {
        EntityManager em = this.emf.createEntityManager();
        em.joinTransaction();
        em.persist((Object)new ContextMappingInfo(this.resolveContext(context, em).getContextId().toString(), ksessionId));
        em.close();
    }

    public Integer findMapping(Context context) {
        EntityManager em = this.emf.createEntityManager();
        ContextMappingInfo contextMapping = this.findContextByContextId(this.resolveContext(context, em), em);
        if (contextMapping != null) {
            return contextMapping.getKsessionId();
        }
        return null;
    }

    public void removeMapping(Context context) {
        EntityManager em = this.emf.createEntityManager();
        em.joinTransaction();
        ContextMappingInfo contextMapping = this.findContextByContextId(this.resolveContext(context, em), em);
        if (contextMapping != null) {
            em.remove((Object)contextMapping);
        }
        em.close();
    }

    protected Context resolveContext(Context orig, EntityManager em) {
        if (orig instanceof CorrelationKeyContext) {
            return this.getProcessInstanceByCorrelationKey((CorrelationKey)orig.getContextId(), em);
        }
        return orig;
    }

    protected ContextMappingInfo findContextByContextId(Context context, EntityManager em) {
        try {
            Query findQuery = em.createNamedQuery("FindContextMapingByContextId").setParameter("contextId", (Object)context.getContextId().toString());
            ContextMappingInfo contextMapping = (ContextMappingInfo)findQuery.getSingleResult();
            return contextMapping;
        }
        catch (NoResultException e) {
            return null;
        }
        catch (NonUniqueResultException e) {
            return null;
        }
    }

    public Context getProcessInstanceByCorrelationKey(CorrelationKey correlationKey, EntityManager em) {
        Query processInstancesForEvent = em.createNamedQuery("GetProcessInstanceIdByCorrelation");
        processInstancesForEvent.setParameter("elem_count", (Object)correlationKey.getProperties().size());
        ArrayList<Object> properties = new ArrayList<Object>();
        for (CorrelationProperty property : correlationKey.getProperties()) {
            properties.add(property.getValue());
        }
        processInstancesForEvent.setParameter("properties", properties);
        try {
            return ProcessInstanceIdContext.get((Long)((Long)processInstancesForEvent.getSingleResult()));
        }
        catch (NonUniqueResultException e) {
            return null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object findContextId(Integer ksessionId) {
        EntityManager em = this.emf.createEntityManager();
        try {
            Query findQuery = em.createNamedQuery("FindContextMapingByKSessionId").setParameter("ksessionId", (Object)ksessionId);
            ContextMappingInfo contextMapping = (ContextMappingInfo)findQuery.getSingleResult();
            String string = contextMapping.getContextId();
            return string;
        }
        catch (NoResultException e) {
            Object var4_7 = null;
            return var4_7;
        }
        catch (NonUniqueResultException e) {
            Object var4_8 = null;
            return var4_8;
        }
        finally {
            em.close();
        }
    }
}

