/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import org.jboss.logging.Logger;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.XnioExecutor;
import org.xnio.nio.Log;
import org.xnio.nio.NioHandle;
import org.xnio.nio.NioXnioWorker;

final class WorkerThread
extends Thread
implements XnioExecutor {
    private static final long LONGEST_DELAY = 9223372036853L;
    private static final String FQCN = WorkerThread.class.getName();
    private static final String NH_FQCN = NioHandle.class.getName();
    private final NioXnioWorker worker;
    private final Selector selector;
    private final Object workLock = new Object();
    private final Queue<Runnable> selectorWorkQueue = new ArrayDeque<Runnable>();
    private final Set<TimeKey> delayWorkQueue = new TreeSet<TimeKey>();
    private volatile int state;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    private static final AtomicIntegerFieldUpdater<WorkerThread> stateUpdater = AtomicIntegerFieldUpdater.newUpdater(WorkerThread.class, "state");

    WorkerThread(NioXnioWorker worker, Selector selector, String name, ThreadGroup group, long stackSize) {
        super(group, null, name, stackSize);
        this.selector = selector;
        this.worker = worker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        selector = this.selector;
        try {
            Log.log.tracef("Starting worker thread %s", (Object)this);
            lock = this.workLock;
            workQueue = this.selectorWorkQueue;
            delayQueue = this.delayWorkQueue;
            Log.log.debugf("Started channel thread '%s', selector %s", (Object)WorkerThread.currentThread().getName(), (Object)selector);
            delayTime = 0x7FFFFFFFFFFFFFFFL;
            while (true) {
                var13_12 = lock;
                synchronized (var13_12) {
                    task = workQueue.poll();
                    if (task == null) {
                        iterator = delayQueue.iterator();
                        delayTime = 0x7FFFFFFFFFFFFFFFL;
                        if (iterator.hasNext()) {
                            now = System.nanoTime();
                            do {
                                if (TimeKey.access$000((TimeKey)(key = iterator.next())) > now) {
                                    delayTime = TimeKey.access$000((TimeKey)key) - now;
                                    break;
                                }
                                workQueue.add(TimeKey.access$100((TimeKey)key));
                                iterator.remove();
                            } while (iterator.hasNext());
                        }
                        task = workQueue.poll();
                    }
                }
                WorkerThread.safeRun(task);
                if (task != null) continue;
                oldState = this.state;
                if ((oldState & -2147483648) != 0) {
                    var13_12 = lock;
                    synchronized (var13_12) {
                        block44: {
                            keyCount = selector.keys().size();
                            this.state = keyCount | -2147483648;
                            if (keyCount != 0 || !workQueue.isEmpty()) break block44;
                            return;
                        }
                        ** try [egrp 4[TRYBLOCK] [3 : 280->286)] { 
                        {
                        }
                    }
lbl47:
                    // 1 sources

                    var13_12 = selector;
                    synchronized (var13_12) {
                        var15_23 = keySet = selector.keys();
                        synchronized (var15_23) {
                            keys = keySet.toArray();
                        }
                    }
                    for (Object key : keys) {
                        attachment = (NioHandle)((SelectionKey)key).attachment();
                        if (attachment == null) continue;
                        IoUtils.safeClose(attachment.getChannel());
                    }
                }
                try {
                    if ((oldState & -2147483648) != 0) {
                        Log.selectorLog.tracef("Beginning select on %s (shutdown in progress)", (Object)selector);
                        selector.selectNow();
                    } else if (delayTime == 0x7FFFFFFFFFFFFFFFL) {
                        Log.selectorLog.tracef("Beginning select on %s", (Object)selector);
                        selector.select();
                    } else {
                        millis = 1L + delayTime / 1000000L;
                        Log.selectorLog.tracef("Beginning select on %s (with timeout)", (Object)selector);
                        selector.select(millis);
                    }
                }
                catch (CancelledKeyException ignored) {
                    Log.selectorLog.trace((Object)"Spurious cancelled key exception");
                }
                catch (IOException e) {
                    Log.selectorLog.warnf("Received an I/O error on selection: %s", (Object)e);
                }
                Log.selectorLog.tracef("Selected on %s", (Object)selector);
                e = selector;
                synchronized (e) {
                    len$ = selectedKeys = selector.selectedKeys();
                    synchronized (len$) {
                        keys = selectedKeys.toArray();
                        selectedKeys.clear();
                    }
                }
                arr$ = keys;
                len$ = arr$.length;
                i$ = 0;
                while (true) {
                    if (i$ >= len$) ** break;
                    keyObject = arr$[i$];
                    key = (SelectionKey)keyObject;
                    try {
                        ops = key.interestOps();
                        if (ops != 0) {
                            Log.selectorLog.tracef("Selected key %s for %s", (Object)key, (Object)key.channel());
                            handle = (NioHandle)key.attachment();
                            if (handle == null) {
                                this.cancelKey(key);
                            } else {
                                handle.run();
                            }
                        }
                    }
                    catch (CancelledKeyException ignored) {
                        Log.selectorLog.tracef("Skipping selection of cancelled key %s", (Object)key);
                    }
                    catch (Throwable t) {
                        Log.selectorLog.tracef(t, "Unexpected failure of selection of key %s", (Object)key);
                    }
                    ++i$;
                }
                break;
            }
        }
        finally {
            Log.log.tracef("Shutting down channel thread \"%s\"", (Object)this);
            IoUtils.safeClose((Selector)selector);
            this.worker.closeResource();
        }
    }

    private static void safeRun(Runnable command) {
        if (command != null) {
            try {
                Log.log.tracef("Running task %s", (Object)command);
                command.run();
            }
            catch (Throwable t) {
                Log.log.error((Object)"Task failed on channel thread", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) {
        if ((this.state & Integer.MIN_VALUE) != 0) {
            throw new RejectedExecutionException("Thread is terminating");
        }
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(command);
        }
        this.selector.wakeup();
    }

    void shutdown() {
        int oldState;
        do {
            if (((oldState = this.state) & Integer.MIN_VALUE) == 0) continue;
            return;
        } while (!stateUpdater.compareAndSet(this, oldState, oldState | Integer.MIN_VALUE));
        this.selector.wakeup();
    }

    public XnioExecutor.Key executeAfter(Runnable command, long time, TimeUnit unit) {
        return this.executeAfter(command, unit.toMillis(time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    XnioExecutor.Key executeAfter(Runnable command, long time) {
        if ((this.state & Integer.MIN_VALUE) != 0) {
            throw new RejectedExecutionException("Thread is terminating");
        }
        if (time <= 0L) {
            this.execute(command);
            return XnioExecutor.Key.IMMEDIATE;
        }
        long deadline = System.nanoTime() + Math.min(time, 9223372036853L) * 1000000L;
        TimeKey key = new TimeKey(deadline, command);
        Object object = this.workLock;
        synchronized (object) {
            Set<TimeKey> queue = this.delayWorkQueue;
            queue.add(key);
            if (queue.iterator().next() == key) {
                this.selector.wakeup();
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <C extends Channel> NioHandle<C> addChannel(AbstractSelectableChannel channel, C xnioChannel, int ops, ChannelListener.SimpleSetter<C> setter) throws ClosedChannelException {
        SelectionKey key;
        if (WorkerThread.currentThread() == this) {
            Log.log.logf(FQCN, Logger.Level.TRACE, null, "Adding channel %s to %s for XNIO channel %s (same thread)", (Object)channel, (Object)this, xnioChannel);
            SelectionKey key2 = channel.register(this.selector, 0);
            NioHandle<C> handle = new NioHandle<C>(key2, this, setter, xnioChannel);
            key2.attach(handle);
            if (ops != 0) {
                key2.interestOps(ops);
            }
            return handle;
        }
        Log.log.logf(FQCN, Logger.Level.TRACE, null, "Adding channel %s to %s for XNIO channel %s (other thread)", (Object)channel, (Object)this, xnioChannel);
        SynchTask task = new SynchTask();
        this.queueTask(task);
        try {
            this.selector.wakeup();
            key = channel.register(this.selector, 0);
        }
        finally {
            task.done();
        }
        NioHandle<C> handle = new NioHandle<C>(key, this, setter, xnioChannel);
        key.attach(handle);
        if (ops != 0) {
            key.interestOps(ops);
        }
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueTask(Runnable task) {
        Object object = this.workLock;
        synchronized (object) {
            this.selectorWorkQueue.add(task);
        }
    }

    void cancelKey(SelectionKey key) {
        assert (key.selector() == this.selector);
        SelectableChannel channel = key.channel();
        if (WorkerThread.currentThread() == this) {
            Log.log.logf(FQCN, Logger.Level.TRACE, null, "Cancelling key %s of %s (same thread)", (Object)key, (Object)channel);
            try {
                key.cancel();
                try {
                    this.selector.selectNow();
                }
                catch (IOException e) {
                    Log.log.warnf("Received an I/O error on selection: %s", (Object)e);
                }
            }
            catch (Throwable t) {
                Log.log.logf(FQCN, Logger.Level.TRACE, t, "Error cancelling key %s of %s (same thread)", (Object)key, (Object)channel);
            }
        } else {
            Log.log.logf(FQCN, Logger.Level.TRACE, null, "Cancelling key %s of %s (other thread)", (Object)key, (Object)channel);
            try {
                key.cancel();
                this.selector.wakeup();
            }
            catch (Throwable t) {
                Log.log.logf(FQCN, Logger.Level.TRACE, t, "Error cancelling key %s of %s (other thread)", (Object)key, (Object)channel);
            }
        }
    }

    void setOps(SelectionKey key, int ops) {
        assert (key.selector() == this.selector);
        SelectableChannel channel = key.channel();
        if (WorkerThread.currentThread() == this) {
            if (Log.log.isTraceEnabled()) {
                Log.log.logf(NH_FQCN, Logger.Level.TRACE, null, "Setting operations of key %s of %s to %02x (same thread)", (Object)key, (Object)channel, (Object)ops);
            }
            try {
                key.interestOps(ops);
            }
            catch (CancelledKeyException ignored) {}
        } else {
            if (Log.log.isTraceEnabled()) {
                Log.log.logf(NH_FQCN, Logger.Level.TRACE, null, "Setting operations of key %s of %s to %02x (other thread)", (Object)key, (Object)channel, (Object)ops);
            }
            try {
                key.interestOps(ops);
                this.selector.wakeup();
            }
            catch (CancelledKeyException ignored) {
                // empty catch block
            }
        }
    }

    int getOps(SelectionKey key) {
        assert (key.selector() == this.selector);
        try {
            return key.interestOps();
        }
        catch (CancelledKeyException ignored) {
            return 0;
        }
    }

    Selector getSelector() {
        return this.selector;
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    final class SynchTask
    implements Runnable {
        volatile boolean done = false;

        SynchTask() {
        }

        @Override
        public void run() {
            while (!this.done) {
                LockSupport.park();
            }
        }

        void done() {
            this.done = true;
            LockSupport.unpark(WorkerThread.this);
        }
    }

    final class TimeKey
    implements XnioExecutor.Key,
    Comparable<TimeKey> {
        private final long deadline;
        private final Runnable command;

        TimeKey(long deadline, Runnable command) {
            this.deadline = deadline;
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove() {
            Object object = WorkerThread.this.workLock;
            synchronized (object) {
                return WorkerThread.this.delayWorkQueue.remove(this);
            }
        }

        @Override
        public int compareTo(TimeKey o) {
            return (int)Math.signum(this.deadline - o.deadline);
        }

        static /* synthetic */ long access$000(TimeKey x0) {
            return x0.deadline;
        }

        static /* synthetic */ Runnable access$100(TimeKey x0) {
            return x0.command;
        }
    }
}

