/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.shrinkwrap.resolver.api.ResolverSystem;
import org.jboss.shrinkwrap.resolver.api.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResolverSystemFactory {
    private static final String CLASS_NAME_SERVICELOADER = "org.jboss.shrinkwrap.resolver.spi.loader.ServiceLoader";
    private static final String CLASS_NAME_SPISERVICELOADER = "org.jboss.shrinkwrap.resolver.spi.loader.SpiServiceLoader";
    private static final String CLASS_NAME_SERVICEREGISTRY = "org.jboss.shrinkwrap.resolver.spi.loader.ServiceRegistry";
    private static final String METHOD_NAME_ONLY_ONE = "onlyOne";
    private static final String METHOD_NAME_REGISTER = "register";

    private ResolverSystemFactory() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static <RESOLVERSYSTEMTYPE extends ResolverSystem> RESOLVERSYSTEMTYPE createFromUserView(Class<RESOLVERSYSTEMTYPE> userViewClass) throws IllegalArgumentException {
        return ResolverSystemFactory.createFromUserView(userViewClass, SecurityActions.getThreadContextClassLoader());
    }

    static <RESOLVERSYSTEMTYPE extends ResolverSystem> RESOLVERSYSTEMTYPE createFromUserView(Class<RESOLVERSYSTEMTYPE> userViewClass, ClassLoader cl) {
        assert (userViewClass != null) : "user view class must be specified";
        assert (cl != null) : "ClassLoader must be specified";
        try {
            Class<?> spiServiceLoaderClass = cl.loadClass(CLASS_NAME_SPISERVICELOADER);
            Constructor<?> serviceLoaderCtor = spiServiceLoaderClass.getConstructor(ClassLoader.class);
            Object spiServiceLoader = serviceLoaderCtor.newInstance(cl);
            Method onlyOneMethod = spiServiceLoader.getClass().getMethod(METHOD_NAME_ONLY_ONE, Class.class, Class.class);
            Object serviceLoader = onlyOneMethod.invoke(spiServiceLoader, spiServiceLoaderClass, spiServiceLoader.getClass());
            Class<?> serviceRegistryClass = cl.loadClass(CLASS_NAME_SERVICEREGISTRY);
            Class<?> serviceLoaderClass = cl.loadClass(CLASS_NAME_SERVICELOADER);
            Constructor<?> serviceRegistryCtor = serviceRegistryClass.getConstructor(serviceLoaderClass);
            Object serviceRegistry = serviceRegistryCtor.newInstance(serviceLoader);
            Method registerMethod = serviceRegistry.getClass().getMethod(METHOD_NAME_REGISTER, serviceRegistry.getClass());
            registerMethod.invoke(null, serviceRegistry);
            Method onlyOneMethodSingleArg = serviceRegistry.getClass().getMethod(METHOD_NAME_ONLY_ONE, Class.class);
            Object userViewObject = onlyOneMethodSingleArg.invoke(serviceRegistry, userViewClass);
            return (RESOLVERSYSTEMTYPE)((ResolverSystem)userViewClass.cast(userViewObject));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create object from user view", e);
        }
    }
}

