/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.sunxacml;

import com.sun.xacml.Indenter;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.Policy;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import com.sun.xacml.finder.impl.SelectorModule;
import com.sun.xacml.support.finder.URLPolicyFinderModule;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.sunxacml.EnclosingPolicyFinderModule;

public class JBossXACMLUtil {
    private static Logger log = Logger.getLogger(JBossXACMLUtil.class);
    private static boolean trace = log.isTraceEnabled();

    public static int analyzeResponseCtx(ResponseCtx response) throws Exception {
        Result res;
        int decision;
        if (trace) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            response.encode((OutputStream)baos, new Indenter());
            log.trace((Object)("XACML Response:" + baos.toString()));
            baos.close();
        }
        int result = -1;
        Set results = response.getResults();
        if (results.size() > 1) {
            throw new IllegalArgumentException("Number of results > 1");
        }
        Iterator iter = results.iterator();
        if (iter.hasNext() && (decision = (res = (Result)iter.next()).getDecision()) == 0) {
            result = 1;
        }
        return result;
    }

    public static synchronized int checkXACMLAuthorization(RequestCtx request, Policy policy) throws Exception {
        ResponseCtx response = JBossXACMLUtil.getXACMLResponse(request, policy);
        return JBossXACMLUtil.analyzeResponseCtx(response);
    }

    public static URI getDefaultPolicyID() {
        URI policyID = null;
        try {
            policyID = new URI("urn:org:jboss:xacml:support:finder:dynamic-policy-set");
        }
        catch (Exception e) {
            log.debug((Object)"Exception in getDefaultPolicyID:", (Throwable)e);
        }
        return policyID;
    }

    public static synchronized ResponseCtx getXACMLResponse(RequestCtx request, Policy policy) {
        AttributeFinder attributeFinder = new AttributeFinder();
        ArrayList<Object> attributeModules = new ArrayList<Object>();
        attributeModules.add(new CurrentEnvModule());
        attributeModules.add(new SelectorModule());
        attributeFinder.setModules(attributeModules);
        PolicyFinder policyFinder = new PolicyFinder();
        HashSet<EnclosingPolicyFinderModule> policyModules = new HashSet<EnclosingPolicyFinderModule>();
        policyModules.add(new EnclosingPolicyFinderModule(policy));
        policyModules.add((EnclosingPolicyFinderModule)new URLPolicyFinderModule());
        policyFinder.setModules(policyModules);
        PDP pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
        return pdp.evaluate(request);
    }
}

