/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import com.sun.xacml.Policy;
import com.sun.xacml.ctx.RequestCtx;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;
import org.jboss.security.authorization.modules.ejb.EJBXACMLUtil;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.authorization.sunxacml.JBossXACMLUtil;
import org.jboss.security.identity.RoleGroup;

public class EJBXACMLPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Principal principal = null;
    private String policyContextID = null;

    public EJBXACMLPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw new IllegalArgumentException("resource is not an EJBResource");
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        if (this.policyRegistration == null) {
            throw new IllegalStateException("Policy Registration passed is null");
        }
        this.ejbName = ejbResource.getEjbName();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.principal = ejbResource.getPrincipal();
        this.policyContextID = ejbResource.getPolicyContextID();
        if (this.policyContextID == null) {
            throw new IllegalStateException("Context ID is null");
        }
        Boolean roleRefCheck = this.checkBooleanValue((Boolean)map.get("roleRefPermissionCheck"));
        if (roleRefCheck.booleanValue()) {
            throw new IllegalStateException("SECURITY-50:Role Ref checks not implemented");
        }
        return this.process(role);
    }

    private int process(RoleGroup callerRoles) {
        int result = -1;
        EJBXACMLUtil util = new EJBXACMLUtil();
        try {
            RequestCtx requestCtx = util.createXACMLRequest(this.ejbName, this.ejbMethod.getName(), this.principal, callerRoles);
            Policy policy = (Policy)this.policyRegistration.getPolicy(this.policyContextID, null);
            if (policy == null) {
                if (this.trace) {
                    log.trace((Object)("Policy obtained is null for contextID:" + this.policyContextID));
                }
                throw new IllegalStateException("Missing xacml policy for contextid:" + this.policyContextID);
            }
            result = JBossXACMLUtil.checkXACMLAuthorization(requestCtx, policy);
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Exception in processing:", (Throwable)e);
            }
            result = -1;
        }
        return result;
    }

    private Boolean checkBooleanValue(Boolean bool) {
        if (bool == null) {
            return Boolean.FALSE;
        }
        return bool;
    }
}

