/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class RetroCheckMojo
extends AbstractMojo {
    public static final String JBOSS_RETRO_ARTIFACTID = "jboss-retro";
    protected MavenProject project;
    protected MavenProjectHelper projectHelper;
    protected ArtifactFactory artifactFactory;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    private String jvm;
    protected List pluginComponents;
    private List pluginArtifacts;
    private String checkDirectory;
    private boolean verbose = false;
    private boolean suppress = false;
    private File jbossRetroCheckJar = null;
    private File jbossRetroRtJar = null;
    private boolean ignoreErrors = false;

    public void execute() throws MojoExecutionException {
        if (this.jvm == null || this.jvm.equals("") || !new File(this.jvm).exists()) {
            this.getLog().error((CharSequence)("Unable to locate jvm: " + this.jvm));
            this.getLog().error((CharSequence)"Skipping retro check");
            return;
        }
        this.resolveCheckerLocation();
        this.getLog().info((CharSequence)"Checking classes for jdk14");
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-cp");
        String classpath = this.createCheckerClasspath();
        this.getLog().debug((CharSequence)("Using checker classpath: " + classpath));
        argsList.add(classpath);
        argsList.add("org.jboss.ant.tasks.retrocheck.Checker");
        if (this.verbose) {
            argsList.add("-verbose");
        }
        if (this.suppress) {
            argsList.add("-suppress");
        }
        String retroClassesDir = this.project.getBuild().getDirectory() + File.separator + this.checkDirectory;
        argsList.add(retroClassesDir);
        String[] args = new String[argsList.size()];
        args = argsList.toArray(args);
        Commandline cli = new Commandline();
        cli.setExecutable(this.jvm);
        cli.addArguments(args);
        MojoLogStreamConsumer out = new MojoLogStreamConsumer();
        MojoLogStreamConsumer err = new MojoLogStreamConsumer();
        try {
            int returnCode = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)out, (StreamConsumer)err);
            if (!this.ignoreErrors && returnCode != 0) {
                throw new MojoExecutionException("There were errors during the retro check");
            }
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Error while executing forked tests.", (Exception)((Object)e));
        }
    }

    public String createCheckerClasspath() {
        StringBuilder classpath = new StringBuilder();
        String fileSep = System.getProperty("file.separator");
        String weavedClassesDir = this.project.getBuild().getDirectory() + fileSep + this.checkDirectory;
        classpath.append(weavedClassesDir);
        classpath.append(File.pathSeparator);
        for (Object artifactObj : this.pluginArtifacts) {
            Artifact artifact = (Artifact)artifactObj;
            if (artifact.getArtifactId().equals(JBOSS_RETRO_ARTIFACTID) && artifact.getClassifier() == null) continue;
            try {
                File artifactFile = artifact.getFile();
                if (artifactFile == null) continue;
                classpath.append(artifactFile.getCanonicalPath());
                classpath.append(File.pathSeparator);
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)"Could not get filename");
            }
        }
        classpath.append(this.jbossRetroCheckJar.getAbsolutePath());
        classpath.append(File.pathSeparator);
        classpath.append(this.jbossRetroRtJar.getAbsolutePath());
        classpath.append(File.pathSeparator);
        return classpath.toString();
    }

    public void resolveCheckerLocation() throws MojoExecutionException {
        String jbossRetroVersion = null;
        if (this.project.getArtifactId().equals(JBOSS_RETRO_ARTIFACTID)) {
            jbossRetroVersion = this.project.getVersion();
            List attachedArtifacts = this.project.getAttachedArtifacts();
            for (Object artifactObj : attachedArtifacts) {
                Artifact artifact = (Artifact)artifactObj;
                if (!artifact.getArtifactId().equals(JBOSS_RETRO_ARTIFACTID)) continue;
                if (artifact.getClassifier().equals("retrocheck")) {
                    this.jbossRetroCheckJar = artifact.getFile();
                    continue;
                }
                if (!artifact.getClassifier().equals("rt")) continue;
                this.jbossRetroRtJar = artifact.getFile();
            }
        }
        if (this.jbossRetroCheckJar != null && this.jbossRetroRtJar != null) {
            return;
        }
        Iterator iter = this.pluginArtifacts.iterator();
        while (iter.hasNext() && jbossRetroVersion == null) {
            Artifact nextArtifact = (Artifact)iter.next();
            if (!nextArtifact.getArtifactId().equals(JBOSS_RETRO_ARTIFACTID) || nextArtifact.getClassifier() != null) continue;
            jbossRetroVersion = nextArtifact.getVersion();
        }
        Artifact checkerArtifact = this.artifactFactory.createArtifactWithClassifier("org.jboss", JBOSS_RETRO_ARTIFACTID, jbossRetroVersion, "jar", "retrocheck");
        Artifact runtimeArtifact = this.artifactFactory.createArtifactWithClassifier("org.jboss", JBOSS_RETRO_ARTIFACTID, jbossRetroVersion, "jar", "rt");
        try {
            this.artifactResolver.resolve(checkerArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
            this.artifactResolver.resolve(runtimeArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactResolutionException are) {
            throw new MojoExecutionException("Problem resolving artifact: " + (Object)((Object)are));
        }
        catch (ArtifactNotFoundException are) {
            throw new MojoExecutionException("Problem resolving artifact: " + (Object)((Object)are));
        }
        this.jbossRetroCheckJar = checkerArtifact.getFile();
        this.jbossRetroRtJar = runtimeArtifact.getFile();
    }

    public class MojoLogStreamConsumer
    implements StreamConsumer {
        public void consumeLine(String line) {
            RetroCheckMojo.this.getLog().info((CharSequence)line);
        }
    }
}

