/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.Base64;
import java.util.Objects;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import org.jboss.logmanager.errormanager.HandlerErrorManager;
import org.jboss.logmanager.formatters.Formatters;
import org.jboss.logmanager.handlers.JDKSpecific;
import org.jboss.logmanager.handlers.OutputStreamHandler;
import org.jboss.logmanager.handlers.UncloseableOutputStream;
import org.jboss.logmanager.handlers.UncloseableWriter;

public class ConsoleHandler
extends OutputStreamHandler {
    private static final OutputStream out = System.out;
    private static final OutputStream err = System.err;
    private final ErrorManager localErrorManager = new HandlerErrorManager(this);
    private static final String ESC = Character.toString(27);

    public ConsoleHandler() {
        this(Formatters.nullFormatter());
    }

    public ConsoleHandler(Formatter formatter) {
        this(ConsoleHandler.defaultTarget(), formatter);
    }

    public ConsoleHandler(Target target) {
        this(target, Formatters.nullFormatter());
    }

    public ConsoleHandler(Target target, Formatter formatter) {
        super(formatter);
        this.setCharset(JDKSpecific.consoleCharset());
        switch (target.ordinal()) {
            case 0: {
                this.setOutputStream(ConsoleHandler.wrap(out));
                break;
            }
            case 1: {
                this.setOutputStream(ConsoleHandler.wrap(err));
                break;
            }
            case 2: {
                this.setWriter(ConsoleHandler.wrap(ConsoleHolder.console));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void setTarget(Target target) {
        Target t = target == null ? ConsoleHandler.defaultTarget() : target;
        switch (t.ordinal()) {
            case 0: {
                this.setOutputStream(ConsoleHandler.wrap(out));
                break;
            }
            case 1: {
                this.setOutputStream(ConsoleHandler.wrap(err));
                break;
            }
            case 2: {
                this.setWriter(ConsoleHandler.wrap(ConsoleHolder.console));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void setErrorManager(ErrorManager em) {
        if (em == this.localErrorManager) {
            super.setErrorManager(new ErrorManager());
            return;
        }
        super.setErrorManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeImagePng(InputStream imageData, int columns, int rows) throws IOException {
        Objects.requireNonNull(imageData, "imageData");
        columns = Math.max(0, columns);
        rows = Math.max(0, rows);
        if (!ConsoleHandler.isGraphicsSupportPassivelyDetected()) {
            return false;
        }
        this.lock.lock();
        try {
            final Writer writer = this.getWriter();
            if (writer == null) {
                boolean bl = false;
                return bl;
            }
            try (OutputStream os = Base64.getEncoder().wrap(new OutputStream(this){
                final byte[] buffer = new byte[2048];
                int pos = 0;
                final /* synthetic */ ConsoleHandler this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void write(int b) throws IOException {
                    if (this.pos == this.buffer.length) {
                        this.more();
                    }
                    this.buffer[this.pos++] = (byte)b;
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    while (len > 0) {
                        if (this.pos == this.buffer.length) {
                            this.more();
                        }
                        int cnt = Math.min(len, this.buffer.length - this.pos);
                        System.arraycopy(b, off, this.buffer, this.pos, cnt);
                        this.pos += cnt;
                        off += cnt;
                        len -= cnt;
                    }
                }

                void more() throws IOException {
                    writer.write("m=1;");
                    writer.write(new String(this.buffer, 0, this.pos, StandardCharsets.US_ASCII));
                    writer.write(ESC + "\\");
                    writer.write(ESC + "_G");
                    this.pos = 0;
                }

                @Override
                public void close() throws IOException {
                    writer.write("m=0;");
                    writer.write(new String(this.buffer, 0, this.pos, StandardCharsets.US_ASCII));
                    writer.write(ESC + "\\\n");
                    writer.flush();
                    this.pos = 0;
                }
            });){
                writer.write(String.format(ESC + "_Gf=100,a=T,c=%d,r=%d,", columns, rows));
                imageData.transferTo(os);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ErrorManager getLocalErrorManager() {
        return this.localErrorManager;
    }

    private static OutputStream wrap(OutputStream outputStream) {
        return outputStream == null ? null : (outputStream instanceof UncloseableOutputStream ? outputStream : new UncloseableOutputStream(outputStream));
    }

    private static Writer wrap(Writer writer) {
        return writer == null ? null : (writer instanceof UncloseableWriter ? writer : new UncloseableWriter(writer));
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        super.setOutputStream(ConsoleHandler.wrap(outputStream));
    }

    public static boolean hasConsole() {
        return ConsoleHolder.console != null;
    }

    public static boolean isTrueColor() {
        if (!ConsoleHandler.hasConsole()) {
            return false;
        }
        String colorterm = System.getenv("COLORTERM");
        return colorterm != null && (colorterm.contains("truecolor") || colorterm.contains("24bit"));
    }

    public static boolean isGraphicsSupportPassivelyDetected() {
        if (!ConsoleHandler.hasConsole()) {
            return false;
        }
        String term = System.getenv("TERM");
        String termProgram = System.getenv("TERM_PROGRAM");
        return term != null && (term.equalsIgnoreCase("kitty") || term.equalsIgnoreCase("xterm-kitty") || term.equalsIgnoreCase("wezterm") || term.equalsIgnoreCase("konsole")) || termProgram != null && termProgram.equalsIgnoreCase("wezterm");
    }

    private static Target defaultTarget() {
        return ConsoleHolder.console == null ? Target.SYSTEM_OUT : Target.CONSOLE;
    }

    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR,
        CONSOLE;

    }

    private static final class ConsoleHolder {
        private static final PrintWriter console;

        private ConsoleHolder() {
        }

        static {
            AccessController.doPrivileged(() -> {
                String res = System.getProperty("jdk.console");
                if (res == null) {
                    System.setProperty("jdk.console", "java.base");
                }
                return null;
            });
            Console cons = System.console();
            console = cons == null ? null : cons.writer();
        }
    }
}

